/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBEncoderDecoder {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXBEncoderDecoder.class);

    private JAXBEncoderDecoder() {
    }

    private static Marshaller createMarshaller(JAXBContext context, Class<?> cls) throws JAXBException {
        Marshaller jm = null;
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{cls});
        }
        jm = context.createMarshaller();
        jm.setProperty("jaxb.encoding", (Object)"UTF-8");
        jm.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return jm;
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, MessagePartInfo part, Object source, AttachmentMarshaller am) {
        block16: {
            Class<?> cls = null;
            if (part != null) {
                cls = part.getTypeClass();
            }
            if (cls == null) {
                Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
            }
            if (cls != null && cls.isArray() && elValue instanceof Collection) {
                Collection col = (Collection)elValue;
                elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), 0));
            }
            try {
                Marshaller u = JAXBEncoderDecoder.createMarshaller(context, cls);
                try {
                    u.setProperty("jaxb.fragment", (Object)true);
                    u.setProperty("jaxb.formatted.output", (Object)false);
                }
                catch (PropertyException e) {
                    // empty catch block
                }
                Object mObj = elValue;
                QName elName = null;
                if (part != null) {
                    elName = part.getConcreteName();
                }
                if (null != elName && !cls.isAnnotationPresent(XmlRootElement.class)) {
                    XmlSchemaElement el;
                    if (mObj.getClass().isArray() && part != null && part.getXmlSchema() instanceof XmlSchemaElement && (el = (XmlSchemaElement)part.getXmlSchema()).getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                        mObj = Arrays.asList(mObj);
                    }
                    mObj = JAXBElement.class.getConstructor(QName.class, Class.class, Object.class).newInstance(elName, cls, mObj);
                }
                u.setSchema(schema);
                if (am != null) {
                    u.setAttachmentMarshaller(am);
                }
                if (source instanceof XMLStreamWriter) {
                    u.marshal(mObj, (XMLStreamWriter)source);
                    break block16;
                }
                if (source instanceof OutputStream) {
                    u.marshal(mObj, (OutputStream)source);
                    break block16;
                }
                if (source instanceof Node) {
                    u.marshal(mObj, (Node)source);
                    break block16;
                }
                if (source instanceof XMLEventWriter) {
                    u.marshal(mObj, (XMLEventWriter)source);
                    break block16;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
            }
            catch (Exception ex) {
                if (ex instanceof MarshalException) {
                    MarshalException marshalEx = (MarshalException)ex;
                    Message faultMessage = new Message("MARSHAL_ERROR", BUNDLE, marshalEx.getLinkedException().getMessage());
                    throw new Fault(faultMessage, (Throwable)ex);
                }
                throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, Object source) {
        JAXBEncoderDecoder.marshall(context, schema, elValue, null, source, null);
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, MessagePartInfo part, Object source) {
        JAXBEncoderDecoder.marshall(context, schema, elValue, part, source, null);
    }

    private static Unmarshaller createUnmarshaller(JAXBContext context, Class<?> cls) throws JAXBException {
        Unmarshaller um = null;
        if (context == null) {
            if (cls == null) {
                throw new IllegalStateException("A JAXBContext or Class to unmarshal must be provided!");
            }
            context = JAXBContext.newInstance((Class[])new Class[]{cls});
        }
        um = context.createUnmarshaller();
        return um;
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source) {
        return JAXBEncoderDecoder.unmarshall(context, schema, source, null, null, true);
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source, MessagePartInfo part, AttachmentUnmarshaller au, boolean unwrap) {
        XmlSchemaElement el;
        QName elName;
        Class<?> clazz = part != null ? part.getTypeClass() : null;
        QName qName = elName = part != null ? part.getConcreteName() : null;
        if (clazz != null && clazz.isArray() && part != null && part.getXmlSchema() instanceof XmlSchemaElement && (el = (XmlSchemaElement)part.getXmlSchema()).getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
            Object obj = JAXBEncoderDecoder.unmarshall(context, schema, source, elName, null, au, unwrap);
            if (clazz.isArray() && obj instanceof List) {
                return ((List)obj).toArray((Object[])Array.newInstance(clazz.getComponentType(), ((List)obj).size()));
            }
            return obj;
        }
        return JAXBEncoderDecoder.unmarshall(context, schema, source, elName, clazz, au, unwrap);
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source, QName elName, Class<?> clazz, AttachmentUnmarshaller au, boolean unwrap) {
        Object obj;
        block7: {
            obj = null;
            try {
                Unmarshaller u = JAXBEncoderDecoder.createUnmarshaller(context, clazz);
                u.setSchema(schema);
                if (au != null) {
                    u.setAttachmentUnmarshaller(au);
                }
                if (source instanceof Node) {
                    obj = clazz != null ? u.unmarshal((Node)source, clazz) : u.unmarshal((Node)source);
                    break block7;
                }
                if (source instanceof XMLStreamReader) {
                    obj = clazz != null ? u.unmarshal((XMLStreamReader)source, clazz) : u.unmarshal((XMLStreamReader)source);
                    break block7;
                }
                if (source instanceof XMLEventReader) {
                    obj = clazz != null ? u.unmarshal((XMLEventReader)source, clazz) : u.unmarshal((XMLEventReader)source);
                    break block7;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
            }
            catch (Exception ex) {
                if (ex instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex;
                    throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex);
                }
                throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
            }
        }
        return unwrap ? JAXBEncoderDecoder.getElementValue(obj) : obj;
    }

    public static Object getElementValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    public static Class<?> getClassFromType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t;
            return Array.newInstance(JAXBEncoderDecoder.getClassFromType(g.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            return JAXBEncoderDecoder.getClassFromType(p.getRawType());
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }
}

