/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.jaxws.AsyncCallbackFuture;
import org.apache.cxf.jaxws.AsyncResponse;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.DispatchAsyncCallable;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchInInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchOutInterceptor;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
extends BindingProviderImpl
implements Dispatch<T>,
MessageObserver {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private Bus bus;
    private Class<T> cl;
    private Executor executor;
    private JAXBContext context;
    private Service.Mode mode;
    private ConduitSelector conduitSelector;

    DispatchImpl(Bus b, Service.Mode m, Class<T> clazz, Executor e, Endpoint ep) {
        this(b, m, null, clazz, e, ep);
    }

    DispatchImpl(Bus b, Service.Mode m, JAXBContext ctx, Class<T> clazz, Executor e, Endpoint ep) {
        super(((JaxWsEndpointImpl)ep).getJaxwsBinding());
        this.bus = b;
        this.executor = e;
        this.context = ctx;
        this.cl = clazz;
        this.mode = m;
        this.getConduitSelector().setEndpoint(ep);
        this.setupEndpointAddressContext(ep);
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            Map<String, Object> requestContext = this.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invoke(T obj, boolean isOneWay) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Dispatch: invoke called");
        }
        Endpoint endpoint = this.getEndpoint();
        Message message = endpoint.getBinding().createMessage();
        if (this.context != null) {
            message.setContent(JAXBContext.class, this.context);
        }
        HashMap<String, Object> reqContext = new HashMap<String, Object>(this.getRequestContext());
        Map<String, Object> respContext = this.getResponseContext();
        respContext.clear();
        ContextPropertiesMapping.mapRequestfromJaxws2Cxf(reqContext);
        message.putAll(reqContext);
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setOutMessage(message);
        this.setExchangeProperties(exchange, endpoint);
        message.setContent(Object.class, obj);
        message.put("org.apache.cxf.client", Boolean.TRUE);
        PhaseInterceptorChain chain = this.getDispatchOutChain(endpoint);
        message.setInterceptorChain(chain);
        this.prepareConduitSelector(message);
        chain.doIntercept(message);
        this.getConduitSelector().complete(exchange);
        if (message.getContent(Exception.class) != null) {
            if (this.getBinding() instanceof SOAPBinding) {
                try {
                    SOAPFault soapFault = SOAPFactory.newInstance().createFault();
                    Fault fault = (Fault)message.getContent(Exception.class);
                    soapFault.setFaultCode(fault.getFaultCode());
                    soapFault.setFaultString(fault.getMessage());
                    SOAPFaultException exception = new SOAPFaultException(soapFault);
                    throw exception;
                }
                catch (SOAPException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)message.getContent(Exception.class));
                throw exception;
            }
            throw new WebServiceException((Throwable)message.getContent(Exception.class));
        }
        if (this.getConduitSelector().selectConduit(message).getBackChannel() != null) {
            // empty if block
        }
        if (!isOneWay) {
            ExchangeImpl exchangeImpl = exchange;
            synchronized (exchangeImpl) {
                Message inMsg = this.waitResponse(exchange);
                respContext.putAll(inMsg);
                ContextPropertiesMapping.mapResponsefromCxf2Jaxws(respContext);
                return this.cl.cast(inMsg.getContent(Object.class));
            }
        }
        return null;
    }

    private Message waitResponse(Exchange exchange) {
        Message inMsg = exchange.getInMessage();
        if (inMsg == null) {
            try {
                exchange.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            inMsg = exchange.getInMessage();
        }
        if (inMsg.getContent(Exception.class) != null) {
            throw new RuntimeException(inMsg.getContent(Exception.class));
        }
        return inMsg;
    }

    private PhaseInterceptorChain getDispatchOutChain(Endpoint endpoint) {
        PhaseManager pm = this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getOutPhases());
        List<Interceptor> il = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        if (endpoint instanceof JaxWsEndpointImpl) {
            Binding jaxwsBinding = ((JaxWsEndpointImpl)endpoint).getJaxwsBinding();
            if (endpoint.getBinding() instanceof SoapBinding) {
                chain.add(new SOAPHandlerInterceptor(jaxwsBinding));
            }
            chain.add(new LogicalHandlerInInterceptor(jaxwsBinding));
        }
        chain.add(new MessageSenderInterceptor());
        chain.add(new DispatchOutInterceptor());
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message message) {
        Endpoint endpoint = this.getEndpoint();
        message = endpoint.getBinding().createMessage(message);
        message.put("org.apache.cxf.client", Boolean.TRUE);
        PhaseManager pm = this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getInPhases());
        message.setInterceptorChain(chain);
        List<Interceptor> il = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add(endpoint.getInInterceptors());
        ArrayList<Interceptor> inInterceptors = new ArrayList<Interceptor>();
        inInterceptors.add(new DispatchInInterceptor(this.cl, this.mode));
        chain.add(inInterceptors);
        try {
            chain.doIntercept(message);
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().setInMessage(message);
                message.getExchange().notifyAll();
            }
        }
    }

    private Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getEndpoint().getService().getExecutor();
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(5);
        }
        if (this.executor == null) {
            System.err.println("Can't not get executor");
        }
        return this.executor;
    }

    private Endpoint getEndpoint() {
        return this.getConduitSelector().getEndpoint();
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        Response<T> r = this.invokeAsync(obj);
        AsyncCallbackFuture callback = new AsyncCallbackFuture(r, asyncHandler);
        this.getExecutor().execute(callback);
        return callback;
    }

    public Response<T> invokeAsync(T obj) {
        FutureTask<T> f = new FutureTask<T>(new DispatchAsyncCallable<T>(this, obj));
        this.getExecutor().execute(f);
        return new AsyncResponse<T>(f, this.cl);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }

    public synchronized ConduitSelector getConduitSelector() {
        if (null == this.conduitSelector) {
            this.conduitSelector = new UpfrontConduitSelector();
        }
        return this.conduitSelector;
    }

    public void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector;
    }

    protected void prepareConduitSelector(Message message) {
        message.getExchange().put(ConduitSelector.class, this.getConduitSelector());
    }

    protected void setExchangeProperties(Exchange exchange, Endpoint endpoint) {
        exchange.put(Service.Mode.class, this.mode);
        exchange.put(Class.class, this.cl);
        exchange.put(Service.class, endpoint.getService());
        exchange.put(Endpoint.class, endpoint);
        exchange.put(MessageObserver.class, this);
        exchange.put(Bus.class, this.bus);
    }
}

