/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.List;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingInfo;

public class JaxWsServerFactoryBean
extends ServerFactoryBean {
    protected boolean doInit;

    public JaxWsServerFactoryBean() {
        this(new JaxWsServiceFactoryBean());
        this.doInit = true;
    }

    public JaxWsServerFactoryBean(JaxWsServiceFactoryBean serviceFactory) {
        this.setServiceFactory(serviceFactory);
        JaxWsSoapBindingConfiguration defConfig = new JaxWsSoapBindingConfiguration(serviceFactory);
        this.setBindingConfig(defConfig);
        this.doInit = true;
    }

    protected Invoker createInvoker() {
        return new JAXWSMethodInvoker(this.getServiceBean());
    }

    protected BindingInfo createBindingInfo() {
        JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        JaxWsImplementorInfo implInfo = sf.getJaxWsImplementorInfo();
        String jaxBid = implInfo.getBindingType();
        String binding = this.getBindingId();
        if (binding == null) {
            binding = jaxBid;
            this.setBindingId(binding);
        }
        if (binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            binding = "http://schemas.xmlsoap.org/soap/";
            this.setBindingId(binding);
            if (this.getBindingConfig() == null) {
                this.setBindingConfig(new JaxWsSoapBindingConfiguration(sf));
            }
        }
        boolean messageMode = implInfo.getServiceMode().equals((Object)Service.Mode.MESSAGE);
        if (this.getBindingConfig() instanceof JaxWsSoapBindingConfiguration) {
            JaxWsSoapBindingConfiguration conf = (JaxWsSoapBindingConfiguration)this.getBindingConfig();
            if (jaxBid.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                conf.setVersion(Soap12.getInstance());
            }
            if (jaxBid.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
                conf.setVersion(Soap12.getInstance());
                conf.setMtomEnabled(true);
            }
            if (jaxBid.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
                conf.setMtomEnabled(true);
            }
            conf.setJaxWsServiceFactoryBean(sf);
        }
        BindingInfo bindingInfo = super.createBindingInfo();
        if (implInfo.isWebServiceProvider()) {
            bindingInfo.setProperty("databinding.disabled", Boolean.TRUE);
            if (bindingInfo instanceof SoapBindingInfo && messageMode && !implInfo.getProviderParameterType().equals(SOAPMessage.class)) {
                bindingInfo.setProperty("disable.header.processing", Boolean.TRUE);
            }
        }
        return bindingInfo;
    }

    public Server create() {
        Server server = super.create();
        this.init();
        return server;
    }

    private synchronized void init() {
        if (this.doInit) {
            try {
                this.injectResources(this.getServiceBean());
                this.buildHandlerChain();
            }
            catch (Exception ex) {
                if (ex instanceof WebServiceException) {
                    throw (WebServiceException)ex;
                }
                throw new WebServiceException("Creation of Endpoint failed", (Throwable)ex);
            }
        }
        this.doInit = false;
    }

    private void buildHandlerChain() {
        AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
        List<Handler> chain = builder.buildHandlerChainFromClass(this.getServiceBean().getClass(), this.getEndpointName());
        for (Handler h : chain) {
            this.injectResources(h);
        }
        ((JaxWsEndpointImpl)this.getServer().getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
    }

    protected void injectResources(Object instance) {
        if (instance != null) {
            ResourceManager resourceManager = this.getBus().getExtension(ResourceManager.class);
            List<ResourceResolver> resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            resourceManager.addResourceResolver(new WebServiceContextResourceResolver());
            ResourceInjector injector = new ResourceInjector(resourceManager);
            injector.inject(instance);
        }
    }
}

