/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.util.ArrayList;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProviderInDatabindingInterceptor
extends AbstractInDatabindingInterceptor {
    Class type;

    public ProviderInDatabindingInterceptor(Class type) {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
        this.type = type;
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        Endpoint e = ex.get(Endpoint.class);
        if (e.getEndpointInfo().getBinding().getOperations().iterator().hasNext()) {
            BindingOperationInfo bop = e.getEndpointInfo().getBinding().getOperations().iterator().next();
            ex.put(BindingOperationInfo.class, bop);
            this.getMessageInfo(message, bop);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.isGET(message)) {
            params.add(null);
            message.setContent(Object.class, params);
            return;
        }
        Service s = ex.get(Service.class);
        if (SOAPMessage.class.equals((Object)this.type)) {
            SOAPMessage msg = message.getContent(SOAPMessage.class);
            params.add(msg);
        } else {
            XMLStreamReader r = message.getContent(XMLStreamReader.class);
            if (r != null) {
                if (r instanceof W3CDOMStreamReader) {
                    Element nd = ((W3CDOMStreamReader)r).getCurrentElement();
                    DataReader<Node> reader = s.getDataBinding().createReader(Node.class);
                    Object object = reader.read(null, nd, this.type);
                    params.add(object);
                } else {
                    DataReader<XMLStreamReader> reader = s.getDataBinding().createReader(XMLStreamReader.class);
                    Object object = reader.read(null, r, this.type);
                    params.add(object);
                }
            }
        }
        message.setContent(Object.class, params);
    }
}

