/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.phase;

import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.util.SortedArraySet;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPhaseInterceptor<T extends Message>
implements PhaseInterceptor<T> {
    private final String id;
    private String phase;
    private final Set<String> before = new SortedArraySet<String>();
    private final Set<String> after = new SortedArraySet<String>();

    public AbstractPhaseInterceptor() {
        this(null, null);
    }

    public AbstractPhaseInterceptor(String phase) {
        this(null, phase);
    }

    public AbstractPhaseInterceptor(String i, String p) {
        this.id = i == null ? this.getClass().getName() : i;
        this.phase = p;
    }

    public void addBefore(String i) {
        this.before.add(i);
    }

    public void addAfter(String i) {
        this.after.add(i);
    }

    @Override
    public final Set<String> getAfter() {
        return this.after;
    }

    @Override
    public final Set<String> getBefore() {
        return this.before;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getPhase() {
        return this.phase;
    }

    public void setPhase(String p) {
        this.phase = p;
    }

    @Override
    public void handleFault(T message) {
    }

    public boolean isGET(T message) {
        String method = (String)message.get(Message.HTTP_REQUEST_METHOD);
        return "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
    }
}

