/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvoker
implements Invoker {
    @Override
    public Object invoke(Exchange exchange, Object o) {
        Object serviceObject = this.getServiceObject(exchange);
        BindingOperationInfo bop = exchange.get(BindingOperationInfo.class);
        MethodDispatcher md = (MethodDispatcher)exchange.get(Service.class).get(MethodDispatcher.class.getName());
        Method m = md.getMethod(bop);
        m = AbstractInvoker.matchMethod(m, serviceObject);
        List<Object> params = CastUtils.cast((List)o);
        return this.invoke(exchange, serviceObject, m, params);
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        try {
            Object[] paramArray = new Object[]{};
            if (params != null) {
                paramArray = params.toArray();
            }
            paramArray = this.insertExchange(m, paramArray, exchange);
            Object res = m.invoke(serviceObject, paramArray);
            if (exchange.isOneWay()) {
                return null;
            }
            ArrayList<Object> retList = new ArrayList<Object>();
            if (!m.getReturnType().getName().equals("void")) {
                retList.add(res);
            }
            return retList;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, FaultMode.CHECKED_APPLICATION_FAULT);
            throw new Fault(t);
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw new Fault(e);
        }
    }

    public Object[] insertExchange(Method method, Object[] params, Exchange context) {
        Object[] newParams = params;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (!method.getParameterTypes()[i].equals(Exchange.class)) continue;
            newParams = new Object[params.length + 1];
            for (int j = 0; j < newParams.length; ++j) {
                newParams[j] = j == i ? context : (j > i ? params[j - 1] : params[j]);
            }
        }
        return newParams;
    }

    public abstract Object getServiceObject(Exchange var1);

    private static Method matchMethod(Method methodToMatch, Object targetObject) {
        if (AbstractInvoker.isJdkDynamicProxy(targetObject)) {
            Class<?>[] interfaces = targetObject.getClass().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method m = AbstractInvoker.getMostSpecificMethod(methodToMatch, interfaces[i]);
                if (methodToMatch.equals(m)) continue;
                return m;
            }
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

