/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.Extensible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertiesHolder
implements Extensible {
    private AtomicReference<Map<String, Object>> propertyMap = new AtomicReference();
    private AtomicReference<Object[]> extensors = new AtomicReference();
    private Map<QName, Object> extensionAttributes;

    public Object getProperty(String name) {
        if (null == this.propertyMap.get()) {
            return null;
        }
        return this.propertyMap.get().get(name);
    }

    public <T> T getProperty(String name, Class<T> cls) {
        return cls.cast(this.getProperty(name));
    }

    public void setProperty(String name, Object v) {
        if (null == this.propertyMap.get()) {
            this.propertyMap.compareAndSet(null, new ConcurrentHashMap(4));
        }
        if (v == null) {
            this.propertyMap.get().remove(name);
        } else {
            this.propertyMap.get().put(name, v);
        }
    }

    @Override
    public void addExtensor(Object el) {
        Object[] exts2;
        Object[] exts = this.extensors.get();
        if (exts == null) {
            exts2 = new Object[1];
        } else {
            exts2 = new Object[exts.length + 1];
            for (int i = 0; i < exts.length; ++i) {
                exts2[i] = exts[i];
            }
        }
        exts2[exts2.length - 1] = el;
        if (!this.extensors.compareAndSet(exts, exts2)) {
            this.addExtensor(el);
        }
    }

    @Override
    public <T> T getExtensor(Class<T> cls) {
        Object[] exts = this.extensors.get();
        if (exts == null) {
            return null;
        }
        for (int x = 0; x < exts.length; ++x) {
            if (!cls.isInstance(exts[x])) continue;
            return cls.cast(exts[x]);
        }
        return null;
    }

    @Override
    public <T> List<T> getExtensors(Class<T> cls) {
        Object[] exts = this.extensors.get();
        if (exts == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(exts.length);
        for (int x = 0; x < exts.length; ++x) {
            if (!cls.isInstance(exts[x])) continue;
            list.add(cls.cast(exts[x]));
        }
        return list;
    }

    public AtomicReference<Object[]> getExtensors() {
        return this.extensors;
    }

    @Override
    public Object getExtensionAttribute(QName name) {
        return null == this.extensionAttributes ? null : this.extensionAttributes.get(name);
    }

    @Override
    public Map<QName, Object> getExtensionAttributes() {
        return this.extensionAttributes;
    }

    @Override
    public void addExtensionAttribute(QName name, Object attr) {
        if (null == this.extensionAttributes) {
            this.extensionAttributes = new HashMap<QName, Object>();
        }
        this.extensionAttributes.put(name, attr);
    }

    @Override
    public void setExtensionAttributes(Map<QName, Object> attrs) {
        this.extensionAttributes = attrs;
    }

    public <T> T getTraversedExtensor(T defaultValue, Class<T> type) {
        T extensor = this.getExtensor(type);
        if (extensor == null) {
            return defaultValue;
        }
        return extensor;
    }
}

