/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.HandlerConfigGenerator;

public class SEIGenerator
extends AbstractJAXWSGenerator {
    private static final String SEI_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/sei.vm";

    public SEIGenerator() {
        this.name = "sei.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genSEI") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genServer") || this.env.optionSet("genService");
    }

    private boolean hasHandlerConfig(JavaInterface intf) {
        return intf.getHandlerChains() != null;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
        if (interfaces.size() == 0) {
            ServiceInfo serviceInfo = this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_SEI", LOG, wsdl);
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        for (JavaInterface intf : interfaces.values()) {
            if (this.hasHandlerConfig(intf)) {
                HandlerConfigGenerator handlerGen = new HandlerConfigGenerator();
                handlerGen.setJavaInterface(intf);
                handlerGen.generate(this.getEnvironment());
                String annot = handlerGen.getHandlerAnnotation().toString();
                if (handlerGen.getHandlerAnnotation() != null && !intf.getAnnotations().contains(annot)) {
                    intf.addAnnotation(annot);
                    intf.addImport("javax.jws.HandlerChain");
                }
            }
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setCommonAttributes();
            this.doWrite(SEI_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName()));
        }
    }
}

