/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.HandlerConfigGenerator;

public class ServiceGenerator
extends AbstractJAXWSGenerator {
    private static final String SERVICE_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/service.vm";

    public ServiceGenerator() {
        this.name = "service.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genService") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaServiceClass> serviceClasses = javaModel.getServiceClasses();
        if (serviceClasses.size() == 0) {
            ServiceInfo serviceInfo = this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_SERVICE", LOG, wsdl);
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        for (JavaServiceClass js : serviceClasses.values()) {
            if (js.getHandlerChains() != null) {
                HandlerConfigGenerator handlerGen = new HandlerConfigGenerator();
                handlerGen.setJavaInterface(js);
                handlerGen.generate(this.getEnvironment());
                String annot = handlerGen.getHandlerAnnotation().toString();
                if (handlerGen.getHandlerAnnotation() != null && !js.getAnnotations().contains(annot)) {
                    js.addAnnotation(annot);
                    js.addImport("javax.jws.HandlerChain");
                }
            }
            String url = (String)this.env.get("wsdlurl");
            String location = (String)this.env.get("wsdlLocation");
            if (location == null || "".equals(location)) {
                location = url;
            }
            this.clearAttributes();
            this.setAttributes("service", js);
            this.setAttributes("wsdlLocation", location);
            this.setAttributes("wsdlUrl", url);
            this.setCommonAttributes();
            this.doWrite(SERVICE_TEMPLATE, this.parseOutputName(js.getPackageName(), js.getName()));
        }
    }
}

