/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customiztion.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.FaultProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ParameterProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.SoapBindingAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebMethodAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WebResultAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.WrapperAnnotator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper.MethodMapper;

public class OperationProcessor
extends AbstractProcessor {
    private JavaParameter wrapperRequest;
    private JavaParameter wrapperResponse;

    public OperationProcessor(ToolContext c) {
        super(c);
    }

    public void process(JavaInterface intf, OperationInfo operation) throws ToolException {
        JavaMethod method = new MethodMapper().map(operation);
        method.setInterface(intf);
        this.processMethod(method, operation, null);
        Collection<FaultInfo> faults = operation.getFaults();
        FaultProcessor faultProcessor = new FaultProcessor(this.context);
        faultProcessor.process(method, faults);
        intf.addMethod(method);
    }

    void processMethod(JavaMethod method, OperationInfo operation, JAXWSBinding globalBinding) throws ToolException {
        if (this.isAsynCMethod(method)) {
            return;
        }
        MessageInfo inputMessage = operation.getInput();
        MessageInfo outputMessage = operation.getOutput();
        if (inputMessage == null) {
            LOG.log(Level.WARNING, "NO_INPUT_MESSAGE", new Object[]{operation.getName()});
            Message msg = new Message("INVALID_MEP", LOG, operation.getName());
            throw new ToolException(msg);
        }
        ParameterProcessor paramProcessor = new ParameterProcessor(this.context);
        method.clear();
        paramProcessor.process(method, inputMessage, outputMessage, operation.getParameterOrdering());
        method.annotate(new WebMethodAnnotator());
        if (method.isWrapperStyle()) {
            this.setWrapper(operation);
            method.annotate(new WrapperAnnotator(this.wrapperRequest, this.wrapperResponse));
        }
        method.annotate(new WebResultAnnotator());
        method.annotate(new SoapBindingAnnotator());
        JAXWSBinding opBinding = operation.getExtensor(JAXWSBinding.class);
        boolean enableAsync = false;
        if (globalBinding != null && globalBinding.isEnableAsyncMapping() || opBinding != null && opBinding.isEnableAsyncMapping()) {
            enableAsync = true;
        }
        if (!method.isOneWay() && enableAsync && !this.isAddedAsyMethod(method)) {
            this.addAsyncMethod(method);
        }
        if (globalBinding != null && globalBinding.isEnableMime() || opBinding != null && opBinding.isEnableMime()) {
            method.setMimeEnable(true);
        }
    }

    private void setWrapper(OperationInfo operation) {
        MessagePartInfo inputPart = null;
        if (operation.getInput() != null && operation.getInput().getMessageParts() != null) {
            inputPart = operation.getInput().getMessageParts().iterator().next();
        }
        MessagePartInfo outputPart = null;
        if (operation.getOutput() != null && operation.getOutput().getMessageParts() != null) {
            outputPart = operation.getOutput().getMessageParts().iterator().next();
        }
        if (inputPart != null) {
            this.wrapperRequest = new JavaParameter();
            this.wrapperRequest.setName(ProcessorUtil.resolvePartName(inputPart));
            this.wrapperRequest.setType(ProcessorUtil.getPartType(inputPart));
            this.wrapperRequest.setTargetNamespace(ProcessorUtil.resolvePartNamespace(inputPart));
            this.wrapperRequest.setClassName(ProcessorUtil.getFullClzName(inputPart, this.context, false));
        }
        if (outputPart != null) {
            this.wrapperResponse = new JavaParameter();
            this.wrapperResponse.setName(ProcessorUtil.resolvePartName(outputPart));
            this.wrapperResponse.setType(ProcessorUtil.getPartType(outputPart));
            this.wrapperResponse.setTargetNamespace(ProcessorUtil.resolvePartNamespace(outputPart));
            this.wrapperResponse.setClassName(ProcessorUtil.getFullClzName(outputPart, this.context, false));
        }
    }

    private boolean isAsynCMethod(JavaMethod method) {
        return method.getName().toLowerCase().equals((method.getOperationName() + "Async").toLowerCase());
    }

    private void addAsyncMethod(JavaMethod method) throws ToolException {
        this.addPollingMethod(method);
        this.addCallbackMethod(method);
        method.getInterface().addImport("javax.xml.ws.AsyncHandler");
        method.getInterface().addImport("java.util.concurrent.Future");
        method.getInterface().addImport("javax.xml.ws.Response");
    }

    private void addPollingMethod(JavaMethod method) throws ToolException {
        JavaMethod pollingMethod = new JavaMethod(method.getInterface());
        pollingMethod.setName(method.getName() + "Async");
        pollingMethod.setStyle(method.getStyle());
        pollingMethod.setWrapperStyle(method.isWrapperStyle());
        pollingMethod.setSoapAction(method.getSoapAction());
        pollingMethod.setOperationName(method.getOperationName());
        JavaReturn future = new JavaReturn();
        future.setClassName("Future<?>");
        pollingMethod.setReturn(future);
        pollingMethod.annotate(new WebMethodAnnotator());
        pollingMethod.addAnnotation("ResponseWrapper", method.getAnnotationMap().get("ResponseWrapper"));
        pollingMethod.addAnnotation("RequestWrapper", method.getAnnotationMap().get("RequestWrapper"));
        pollingMethod.addAnnotation("SOAPBinding", method.getAnnotationMap().get("SOAPBinding"));
        Iterator<JavaParameter> iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            pollingMethod.addParameter(iter.next());
        }
        JavaParameter asyncHandler = new JavaParameter();
        asyncHandler.setName("asyncHandler");
        asyncHandler.setClassName(this.getAsyncClassName(method, "AsyncHandler"));
        JavaAnnotation asyncHandlerAnnotation = new JavaAnnotation("WebParam");
        asyncHandlerAnnotation.addArgument("name", "asyncHandler");
        asyncHandlerAnnotation.addArgument("targetNamespace", "");
        asyncHandler.setAnnotation(asyncHandlerAnnotation);
        pollingMethod.addParameter(asyncHandler);
        method.getInterface().addMethod(pollingMethod);
    }

    private void addCallbackMethod(JavaMethod method) throws ToolException {
        JavaMethod callbackMethod = new JavaMethod(method.getInterface());
        callbackMethod.setName(method.getName() + "Async");
        callbackMethod.setStyle(method.getStyle());
        callbackMethod.setWrapperStyle(method.isWrapperStyle());
        callbackMethod.setSoapAction(method.getSoapAction());
        callbackMethod.setOperationName(method.getOperationName());
        JavaReturn response = new JavaReturn();
        response.setClassName(this.getAsyncClassName(method, "Response"));
        callbackMethod.setReturn(response);
        callbackMethod.annotate(new WebMethodAnnotator());
        callbackMethod.addAnnotation("RequestWrapper", method.getAnnotationMap().get("RequestWrapper"));
        callbackMethod.addAnnotation("ResponseWrapper", method.getAnnotationMap().get("ResponseWrapper"));
        callbackMethod.addAnnotation("SOAPBinding", method.getAnnotationMap().get("SOAPBinding"));
        Iterator<JavaParameter> iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            callbackMethod.addParameter(iter.next());
        }
        method.getInterface().addMethod(callbackMethod);
    }

    private String getAsyncClassName(JavaMethod method, String clzName) {
        String response = this.wrapperResponse != null ? this.wrapperResponse.getClassName() : method.getReturn().getClassName();
        StringBuffer sb = new StringBuffer();
        sb.append(clzName);
        sb.append("<");
        sb.append(response);
        sb.append(">");
        return sb.toString();
    }

    private boolean isAddedAsyMethod(JavaMethod method) {
        List<JavaMethod> jmethods = method.getInterface().getMethods();
        int counter = 0;
        for (JavaMethod jm : jmethods) {
            if (!jm.getOperationName().equals(method.getOperationName())) continue;
            ++counter;
        }
        return counter > 1;
    }
}

