/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.http_jetty.spring.JettyHTTPServerEngineFactoryConfig;

public class JettyHTTPServerEngineFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngineFactory.class);
    private static Map<Integer, JettyHTTPServerEngine> portMap = new HashMap<Integer, JettyHTTPServerEngine>();
    private Map<Integer, ThreadingParameters> threadingParametersMap = new TreeMap<Integer, ThreadingParameters>();
    private Map<Integer, TLSServerParameters> tlsParametersMap = new TreeMap<Integer, TLSServerParameters>();
    private Bus bus;
    private JettyHTTPServerEngineFactoryConfig factorySpringConfig;

    @Resource(name="bus")
    public void setBus(Bus bus) {
        assert (this.bus == null);
        this.bus = bus;
    }

    @Resource
    public void setConfig(JettyHTTPServerEngineFactoryConfig config) {
        this.factorySpringConfig = config;
    }

    @PostConstruct
    public void registerWithBus() {
        this.bus.setExtension(this, JettyHTTPServerEngineFactory.class);
    }

    @PostConstruct
    public void configureSpring() {
        if (this.factorySpringConfig != null) {
            this.factorySpringConfig.configureServerEngineFactory(this);
        }
    }

    public void setTLSServerParametersForPort(int port, TLSServerParameters tlsParams) {
        if (tlsParams == null) {
            throw new IllegalArgumentException("tlsParams cannot be null");
        }
        this.tlsParametersMap.put(port, tlsParams);
    }

    public void removeTLSServerParametersForPort(int port) {
        this.tlsParametersMap.remove(port);
    }

    public void setThreadingParametersForPort(int port, ThreadingParameters threadingParams) {
        if (threadingParams == null) {
            throw new IllegalArgumentException("threadingParameters cannot be null");
        }
        this.threadingParametersMap.put(port, threadingParams);
    }

    public void removeThreadingParametersForPort(int port) {
        this.threadingParametersMap.remove(port);
    }

    synchronized JettyHTTPServerEngine retrieveJettyHTTPServerEngine(int port) {
        return portMap.get(port);
    }

    synchronized JettyHTTPServerEngine createJettyHTTPServerEngine(int port) throws GeneralSecurityException, IOException {
        TLSServerParameters tlsParams = this.tlsParametersMap.get(port);
        if (tlsParams != null) {
            throw new RuntimeException("Port " + port + " is configured for TLS");
        }
        JettyHTTPServerEngine ref = new JettyHTTPServerEngine(this, this.bus, port);
        ref.setProgrammaticTlsServerParameters(tlsParams);
        ThreadingParameters tparams = this.threadingParametersMap.get(port);
        if (tparams != null) {
            ref.setThreadingParameters(tparams);
        }
        ref.finalizeConfig();
        portMap.put(port, ref);
        return ref;
    }

    synchronized JettyHTTPServerEngine createJettyHTTPSServerEngine(int port) throws GeneralSecurityException, IOException {
        LOG.fine("Creating Jetty HTTP Server Engine for port " + port + ".");
        JettyHTTPServerEngine ref = new JettyHTTPServerEngine(this, this.bus, port);
        TLSServerParameters tlsParams = this.tlsParametersMap.get(port);
        if (tlsParams == null) {
            throw new RuntimeException("Port " + port + " is not configured for TLS");
        }
        ref.setProgrammaticTlsServerParameters(tlsParams);
        ThreadingParameters threadingParams = this.threadingParametersMap.get(port);
        if (threadingParams != null) {
            ref.setThreadingParameters(threadingParams);
        }
        ref.finalizeConfig();
        portMap.put(port, ref);
        return ref;
    }

    public synchronized void destroyForPort(int port) {
        JettyHTTPServerEngine ref = portMap.remove(port);
        if (ref != null) {
            LOG.fine("Stopping Jetty HTTP Server Engine for port " + port + ".");
            try {
                ref.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @PostConstruct
    public void finalizeConfig() {
        this.registerWithBus();
    }
}

