/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public final class WSAContextUtils {
    private static final String TO_PROPERTY = "org.apache.cxf.ws.addressing.to";
    private static final String REPLYTO_PROPERTY = "org.apache.cxf.ws.addressing.replyto";
    private static final String USING_PROPERTY = "org.apache.cxf.ws.addressing.using";

    private WSAContextUtils() {
    }

    public static void storeUsingAddressing(boolean override, Message message) {
        message.put(USING_PROPERTY, override);
    }

    public static boolean retrieveUsingAddressing(Message message) {
        Boolean override = (Boolean)message.get(USING_PROPERTY);
        return override != null && override != false;
    }

    public static void storeTo(EndpointReferenceType to, Message message) {
        message.put(TO_PROPERTY, to);
    }

    public static EndpointReferenceType retrieveTo(Conduit conduit, Message message) {
        EndpointReferenceType to = null;
        to = conduit != null ? conduit.getTarget() : (EndpointReferenceType)message.get(TO_PROPERTY);
        return to;
    }

    public static void storeReplyTo(EndpointReferenceType replyTo, Message message) {
        message.put(REPLYTO_PROPERTY, replyTo);
    }

    public static EndpointReferenceType retrieveReplyTo(Conduit conduit, Message message) {
        return conduit != null ? conduit.getBackChannel().getAddress() : (EndpointReferenceType)message.get(REPLYTO_PROPERTY);
    }
}

