/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.servant;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.cxf.BusException;
import org.apache.cxf.jca.cxf.JCABusFactory;
import org.apache.cxf.jca.servant.EJBServant;

public class CXFConnectEJBServant
extends EJBServant {
    private static final Logger LOG = Logger.getLogger(CXFConnectEJBServant.class.toString());
    final String loginModuleName = "";
    final String userName = "";
    final String password = "";
    InitialContext appserverInitialContext;
    JCABusFactory jcaBusFactory;

    public CXFConnectEJBServant(JCABusFactory bf, String wsdlLoc, String jndiName, Class sei) throws Exception {
        super(wsdlLoc, bf.getBus(), jndiName, null);
        this.appserverInitialContext = bf.getInitialContext();
        this.jcaBusFactory = bf;
        LOG.info("appserverClassLoader=" + bf.getAppserverClassLoader());
    }

    public JCABusFactory getBusFactory() {
        return this.jcaBusFactory;
    }

    public Context getInitialContext(Properties props) throws NamingException {
        return this.appserverInitialContext;
    }

    public void setInitialContext(InitialContext ic) {
        this.appserverInitialContext = ic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getTargetObject() throws BusException {
        Object retval = null;
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.jcaBusFactory.getAppserverClassLoader());
            retval = super.getTargetObject();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
        LOG.info("target object=" + retval);
        return retval;
    }

    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        return this.doInvoke(target, method, args);
    }

    protected Object doInvoke(Object target, Method method, Object[] args) throws Throwable {
        LOG.info("CXFConnectEJBServant invoke() in thread: " + Thread.currentThread());
        Object retval = null;
        retval = super.invoke(target, method, args);
        return retval;
    }
}

