/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.WSAContextUtils;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPAggregator
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(MAPAggregator.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    protected final Map<String, String> messageIDs = new HashMap<String, String>();
    private Map<Endpoint, Boolean> usingAddressing = new ConcurrentHashMap<Endpoint, Boolean>();
    private boolean allowDuplicates = true;

    public MAPAggregator() {
        super("pre-logical");
    }

    public boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean ad) {
        this.allowDuplicates = ad;
    }

    public void handleMessage(Message message) {
        this.mediate(message, ContextUtils.isFault(message));
    }

    public void handleFault(Message message) {
    }

    private boolean usingAddressing(Message message) {
        boolean ret = false;
        ret = ContextUtils.isRequestor(message) ? WSAContextUtils.retrieveUsingAddressing((Message)message) || this.hasUsingAddressing(message) || this.hasAddressingAssertion(message) : this.getMAPs(message, false, false) != null;
        return ret;
    }

    private boolean hasUsingAddressing(Message message) {
        boolean ret = false;
        Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
        if (null != endpoint) {
            Boolean b = this.usingAddressing.get(endpoint);
            if (null == b) {
                EndpointInfo endpointInfo = endpoint.getEndpointInfo();
                List endpointExts = endpointInfo != null ? endpointInfo.getExtensors(ExtensibilityElement.class) : null;
                List bindingExts = endpointInfo != null && endpointInfo.getBinding() != null ? endpointInfo.getBinding().getExtensors(ExtensibilityElement.class) : null;
                List serviceExts = endpointInfo != null && endpointInfo.getService() != null ? endpointInfo.getService().getExtensors(ExtensibilityElement.class) : null;
                ret = this.hasUsingAddressing(endpointExts) || this.hasUsingAddressing(bindingExts) || this.hasUsingAddressing(serviceExts);
                b = ret ? Boolean.TRUE : Boolean.FALSE;
                this.usingAddressing.put(endpoint, b);
            } else {
                ret = b;
            }
        }
        return ret;
    }

    private boolean hasAddressingAssertion(Message message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == aim) {
            return false;
        }
        Collection ais = (Collection)aim.get((Object)MetadataConstants.ADDRESSING_ASSERTION_QNAME);
        return null != ais && ais.size() != 0;
    }

    private void assertAddressing(Message message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        Collection ais = (Collection)aim.get((Object)MetadataConstants.ADDRESSING_ASSERTION_QNAME);
        if (null == ais || ais.size() == 0) {
            return;
        }
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
    }

    private boolean hasUsingAddressing(List<ExtensibilityElement> exts) {
        boolean found = false;
        if (exts != null) {
            Iterator<ExtensibilityElement> extensionElements = exts.iterator();
            while (extensionElements.hasNext() && !found) {
                ExtensibilityElement ext = extensionElements.next();
                found = Names.WSAW_USING_ADDRESSING_QNAME.equals(ext.getElementType());
            }
        }
        return found;
    }

    protected boolean mediate(Message message, boolean isFault) {
        boolean continueProcessing = true;
        if (ContextUtils.isOutbound(message)) {
            if (this.usingAddressing(message)) {
                this.aggregate(message, isFault);
            }
        } else if (!ContextUtils.isRequestor(message)) {
            AddressingPropertiesImpl maps = this.getMAPs(message, false, false);
            if (null == maps) {
                return false;
            }
            boolean isOneway = message.getExchange().isOneWay();
            continueProcessing = this.validateIncomingMAPs(maps, message);
            if (continueProcessing) {
                message.put(FaultMode.class, (Object)FaultMode.LOGICAL_RUNTIME_FAULT);
                if (isOneway || !ContextUtils.isGenericAddress(maps.getReplyTo())) {
                    ContextUtils.rebaseResponse(maps.getReplyTo(), maps, message);
                }
                if (!isOneway) {
                    ContextUtils.propogateReceivedMAPs((AddressingProperties)maps, message.getExchange());
                }
            } else {
                this.aggregate(message, isFault);
            }
        }
        if (null != ContextUtils.retrieveMAPs(message, false, ContextUtils.isOutbound(message))) {
            this.assertAddressing(message);
        }
        return continueProcessing;
    }

    private void aggregate(Message message, boolean isFault) {
        AddressingPropertiesImpl maps = this.assembleGeneric(message);
        boolean isRequestor = ContextUtils.isRequestor(message);
        this.addRoleSpecific(maps, message, isRequestor, isFault);
        ContextUtils.storeMAPs(maps, message, true, isRequestor);
    }

    private AddressingPropertiesImpl assembleGeneric(Message message) {
        AddressingPropertiesImpl maps = this.getMAPs(message, true, true);
        if (maps.getMessageID() == null) {
            String messageID = ContextUtils.generateUUID();
            maps.setMessageID(ContextUtils.getAttributedURI(messageID));
        }
        if (ContextUtils.hasEmptyAction(maps)) {
            maps.setAction(ContextUtils.getAction(message));
        }
        return maps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRoleSpecific(AddressingPropertiesImpl maps, Message message, boolean isRequestor, boolean isFault) {
        if (isRequestor) {
            EndpointReferenceType replyTo;
            Exchange exchange = message.getExchange();
            boolean isOneway = exchange.isOneWay();
            boolean isOutbound = ContextUtils.isOutbound(message);
            Conduit conduit = null;
            if (maps.getTo() == null) {
                if (isOutbound) {
                    conduit = ContextUtils.getConduit(conduit, message);
                }
                EndpointReferenceType reference = conduit != null ? conduit.getTarget() : ContextUtils.getNoneEndpointReference();
                maps.setTo(reference);
            }
            if (ContextUtils.isGenericAddress(replyTo = maps.getReplyTo())) {
                Destination backChannel;
                if ((conduit = ContextUtils.getConduit(conduit, message)) != null && (backChannel = conduit.getBackChannel()) != null) {
                    replyTo = backChannel.getAddress();
                }
                if (replyTo == null || isOneway) {
                    AttributedURIType address = ContextUtils.getAttributedURI(isOneway ? "http://www.w3.org/2005/08/addressing/none" : "http://www.w3.org/2005/08/addressing/anonymous");
                    replyTo = ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType();
                    replyTo.setAddress(address);
                }
                maps.setReplyTo(replyTo);
            }
            if (isOneway) return;
        }
        AddressingPropertiesImpl inMAPs = this.getMAPs(message, false, false);
        maps.exposeAs(inMAPs.getNamespaceURI());
        if (maps.getTo() == null && inMAPs.getReplyTo() != null) {
            maps.setTo(inMAPs.getReplyTo());
        }
        if (inMAPs.getMessageID() != null && !Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.partial.response"))) {
            String inMessageID = inMAPs.getMessageID().getValue();
            maps.setRelatesTo(ContextUtils.getRelatesTo(inMessageID));
        }
        if (!isFault || ContextUtils.isGenericAddress(inMAPs.getFaultTo())) return;
        ContextUtils.rebaseResponse(inMAPs.getFaultTo(), inMAPs, message);
    }

    private AddressingPropertiesImpl getMAPs(Message message, boolean isProviderContext, boolean isOutbound) {
        AddressingPropertiesImpl maps = null;
        maps = ContextUtils.retrieveMAPs(message, isProviderContext, isOutbound);
        LOG.log(Level.INFO, "MAPs retrieved from message {0}", maps);
        if (maps == null && isProviderContext) {
            maps = new AddressingPropertiesImpl();
        }
        return maps;
    }

    private boolean validateIncomingMAPs(AddressingProperties maps, Message message) {
        AttributedURIType messageID;
        boolean valid = true;
        if (!this.allowDuplicates && maps != null && (messageID = maps.getMessageID()) != null && this.messageIDs.put(messageID.getValue(), messageID.getValue()) != null) {
            LOG.log(Level.WARNING, "DUPLICATE_MESSAGE_ID_MSG", messageID.getValue());
            String reason = BUNDLE.getString("DUPLICATE_MESSAGE_ID_MSG");
            String l7dReason = MessageFormat.format(reason, messageID.getValue());
            ContextUtils.storeMAPFaultName("DuplicateMessageID", message);
            ContextUtils.storeMAPFaultReason(l7dReason, message);
            valid = false;
        }
        return valid;
    }
}

