/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.soap.VersionTransformer;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPCodec
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(MAPCodec.class);
    private static final String IS_REFERENCE_PARAM_ATTR_NAME = "isReferenceParameter";
    protected final Map<String, Exchange> uncorrelatedExchanges = Collections.synchronizedMap(new HashMap());
    private VersionTransformer transformer;
    private HeaderFactory headerFactory;

    public MAPCodec() {
        super("pre-protocol");
        this.addBefore("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor");
        this.transformer = new VersionTransformer(this);
    }

    public Set<QName> getUnderstoodHeaders() {
        return VersionTransformer.HEADERS;
    }

    public void handleMessage(SoapMessage message) {
        this.mediate(message);
    }

    public void handleFault(SoapMessage message) {
    }

    private void mediate(SoapMessage message) {
        if (ContextUtils.isOutbound((Message)message)) {
            this.encode(message, ContextUtils.retrieveMAPs((Message)message, false, true));
        } else if (null == ContextUtils.retrieveMAPs((Message)message, false, false, false)) {
            AddressingProperties maps = this.decode(message);
            ContextUtils.storeMAPs(maps, (Message)message, false);
            this.markPartialResponse(message, maps);
            this.restoreExchange(message, maps);
        }
    }

    private void encode(SoapMessage message, AddressingProperties maps) {
        if (maps != null) {
            this.cacheExchange(message, maps);
            LOG.log(Level.INFO, "Outbound WS-Addressing headers");
            try {
                List header = message.getHeaders();
                this.discardMAPs(header, maps);
                Element hdr = this.getHeaderFactory().getHeader(message.getVersion());
                JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext(maps.getNamespaceURI());
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getMessageID(), "MessageID", AttributedURIType.class, hdr, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getTo(), "To", AttributedURIType.class, hdr, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getReplyTo(), "ReplyTo", EndpointReferenceType.class, hdr, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getFaultTo(), "FaultTo", EndpointReferenceType.class, hdr, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getRelatesTo(), "RelatesTo", RelatesToType.class, hdr, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getAction(), "Action", AttributedURIType.class, hdr, marshaller);
                this.encodeReferenceParameters(maps, hdr, marshaller);
                NodeList children = hdr.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node node = children.item(i);
                    if (node instanceof Element) {
                        ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa", maps.getNamespaceURI());
                    }
                    Header holder = new Header(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node);
                    header.add(holder);
                }
                this.propogateAction(maps.getAction(), message);
                this.applyMAPValidation(message);
            }
            catch (JAXBException je) {
                LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
            }
        }
    }

    private void encodeReferenceParameters(AddressingProperties maps, Element header, Marshaller marshaller) throws JAXBException {
        ReferenceParametersType params;
        EndpointReferenceType toEpr = maps.getToEndpointReference();
        if (null != toEpr && null != (params = toEpr.getReferenceParameters())) {
            for (Object o : params.getAny()) {
                if (o instanceof Element || o instanceof JAXBElement) {
                    JAXBElement jaxbEl = null;
                    if (o instanceof Element) {
                        Element e = (Element)o;
                        QName elQn = new QName(e.getNamespaceURI(), e.getLocalName());
                        jaxbEl = new JAXBElement(elQn, String.class, (Object)e.getTextContent());
                    } else {
                        jaxbEl = (JAXBElement)o;
                    }
                    marshaller.marshal((Object)jaxbEl, (Node)header);
                    Element lastAdded = (Element)header.getLastChild();
                    this.addIsReferenceParameterMarkerAttribute(lastAdded);
                    continue;
                }
                LOG.log(Level.WARNING, "IGNORE_NON_ELEMENT_REF_PARAM_MSG", o);
            }
        }
    }

    private void addIsReferenceParameterMarkerAttribute(Element lastAdded) {
        Attr isRefParamAttr = lastAdded.getOwnerDocument().createAttributeNS("wsa", IS_REFERENCE_PARAM_ATTR_NAME);
        isRefParamAttr.setTextContent("1");
        isRefParamAttr.setPrefix("wsa");
        lastAdded.setAttributeNodeNS(isRefParamAttr);
    }

    private <T> void encodeAsExposed(String exposeAs, T value, String localName, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value != null) {
            LOG.log(Level.INFO, "{0} : {1}", new Object[]{localName, this.getLogText(value)});
            this.transformer.encodeAsExposed(exposeAs, value, localName, clz, header, marshaller);
        }
    }

    public AddressingProperties unmarshalMAPs(SoapMessage message) {
        AddressingPropertiesImpl maps = null;
        try {
            List header = message.getHeaders();
            if (header != null) {
                LOG.log(Level.INFO, "Inbound WS-Addressing headers");
                Unmarshaller unmarshaller = null;
                HashSet<Element> referenceParameterHeaders = null;
                for (Header hdr : header) {
                    if (!(hdr.getObject() instanceof Element)) continue;
                    Element headerElement = (Element)hdr.getObject();
                    String headerURI = headerElement.getNamespaceURI();
                    if (this.transformer.isSupported(headerURI)) {
                        String localName;
                        if (unmarshaller == null) {
                            JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext(headerURI);
                            unmarshaller = jaxbContext.createUnmarshaller();
                        }
                        if (maps == null) {
                            maps = new AddressingPropertiesImpl();
                            maps.exposeAs(headerURI);
                        }
                        if ("MessageID".equals(localName = headerElement.getLocalName())) {
                            maps.setMessageID(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("To".equals(localName)) {
                            AttributedURIType addr = this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller);
                            maps.setTo(EndpointReferenceUtils.getEndpointReference((AttributedURIType)addr));
                            continue;
                        }
                        if ("ReplyTo".equals(localName)) {
                            maps.setReplyTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("FaultTo".equals(localName)) {
                            maps.setFaultTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("RelatesTo".equals(localName)) {
                            maps.setRelatesTo(this.decodeAsNative(headerURI, RelatesToType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if (!"Action".equals(localName)) continue;
                        maps.setAction(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                        continue;
                    }
                    if (null != headerElement.getAttribute(IS_REFERENCE_PARAM_ATTR_NAME)) {
                        if (null == referenceParameterHeaders) {
                            referenceParameterHeaders = new HashSet<Element>();
                        }
                        referenceParameterHeaders.add(headerElement);
                        continue;
                    }
                    if (!headerURI.contains("/addressing")) continue;
                    LOG.log(Level.WARNING, "UNSUPPORTED_VERSION_MSG", headerURI);
                }
                if (null != referenceParameterHeaders && null != maps) {
                    this.decodeReferenceParameters(referenceParameterHeaders, maps, unmarshaller);
                }
            }
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", je);
        }
        return maps;
    }

    private void decodeReferenceParameters(Set<Element> referenceParameterHeaders, AddressingPropertiesImpl maps, Unmarshaller unmarshaller) throws JAXBException {
        EndpointReferenceType toEpr = maps.getToEndpointReference();
        if (null != toEpr) {
            for (Element e : referenceParameterHeaders) {
                JAXBElement el = unmarshaller.unmarshal((Node)e, String.class);
                ContextUtils.applyReferenceParam(toEpr, (JAXBElement<String>)el);
            }
        }
    }

    public <T> T decodeAsNative(String encodedAs, Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        T value = clz.cast(this.transformer.decodeAsNative(encodedAs, clz, headerElement, unmarshaller));
        LOG.log(Level.INFO, "{0} : {1}", new Object[]{headerElement.getLocalName(), this.getLogText(value)});
        return value;
    }

    private <T> String getLogText(T value) {
        String text = "unknown";
        if (value == null) {
            text = "null";
        } else if (value instanceof AttributedURIType) {
            text = ((AttributedURIType)value).getValue();
        } else if (value instanceof EndpointReferenceType) {
            text = ((EndpointReferenceType)value).getAddress() != null ? ((EndpointReferenceType)value).getAddress().getValue() : "null";
        } else if (value instanceof RelatesToType) {
            text = ((RelatesToType)value).getValue();
        }
        return text;
    }

    private AddressingProperties decode(SoapMessage message) {
        return this.unmarshalMAPs(message);
    }

    protected <T> void encodeMAP(T value, QName qname, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value != null) {
            marshaller.marshal((Object)new JAXBElement(qname, clz, value), (Node)header);
        }
    }

    protected <T> T decodeMAP(Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        JAXBElement element = unmarshaller.unmarshal((Node)headerElement, clz);
        return (T)element.getValue();
    }

    private void discardMAPs(List<Header> header, AddressingProperties maps) {
        Iterator<Header> iter = header.iterator();
        while (iter.hasNext()) {
            Header hdr = iter.next();
            if (!"http://www.w3.org/2005/08/addressing".equals(hdr.getName().getNamespaceURI())) continue;
            iter.remove();
        }
    }

    private void propogateAction(AttributedURIType action, SoapMessage message) {
        List soapActionHeaders;
        Map mimeHeaders;
        if (action != null && !"".equals(action.getValue()) && (mimeHeaders = CastUtils.cast((Map)((Map)message.get((Object)"org.apache.cxf.mime.headers")))) != null && (soapActionHeaders = (List)mimeHeaders.get("SOAPAction")) != null && soapActionHeaders.size() != 0 && !"".equals(soapActionHeaders.get(0))) {
            LOG.log(Level.INFO, "encoding wsa:Action in SOAPAction header {0}", action.getValue());
            soapActionHeaders.clear();
            soapActionHeaders.add("\"" + action.getValue() + "\"");
        }
    }

    private void applyMAPValidation(SoapMessage message) {
        String faultName = ContextUtils.retrieveMAPFaultName((Message)message);
        if (faultName != null) {
            String reason = ContextUtils.retrieveMAPFaultReason((Message)message);
            throw this.createSOAPFaut(faultName, "wsa", "http://www.w3.org/2005/08/addressing", reason);
        }
    }

    private SoapFault createSOAPFaut(String localName, String prefix, String namespace, String reason) {
        return new SoapFault(reason, new QName(namespace, localName, prefix));
    }

    private void cacheExchange(SoapMessage message, AddressingProperties maps) {
        if (maps.getRelatesTo() == null) {
            this.uncorrelatedExchanges.put(maps.getMessageID().getValue(), message.getExchange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreExchange(SoapMessage message, AddressingProperties maps) {
        if (maps != null && maps.getRelatesTo() != null) {
            Exchange correlatedExchange = this.uncorrelatedExchanges.remove(maps.getRelatesTo().getValue());
            if (correlatedExchange != null) {
                Exchange exchange = correlatedExchange;
                synchronized (exchange) {
                    Exchange tmpExchange = message.getExchange();
                    message.setExchange(correlatedExchange);
                    Endpoint endpoint = (Endpoint)correlatedExchange.get(Endpoint.class);
                    if (Boolean.TRUE.equals(tmpExchange.get((Object)"deferred.fault.observer.notification")) && endpoint != null) {
                        message.getInterceptorChain().abort();
                        if (endpoint.getInFaultObserver() != null) {
                            endpoint.getInFaultObserver().onMessage((Message)message);
                        }
                    }
                }
            } else {
                LOG.log(Level.WARNING, "CORRELATION_FAILURE_MSG");
                message.getInterceptorChain().abort();
            }
        }
    }

    private void markPartialResponse(SoapMessage message, AddressingProperties maps) {
        if (ContextUtils.isRequestor((Message)message) && null != maps && null == maps.getRelatesTo()) {
            message.put("org.apache.cxf.partial.response", (Object)Boolean.TRUE);
        }
    }

    protected HeaderFactory getHeaderFactory() {
        if (this.headerFactory == null) {
            this.headerFactory = new HeaderFactory(){

                public Element getHeader(SoapVersion soapversion) {
                    Document doc = DOMUtils.createDocument();
                    return doc.createElementNS(soapversion.getHeader().getNamespaceURI(), soapversion.getHeader().getLocalPart());
                }
            };
        }
        return this.headerFactory;
    }

    protected void setHeaderFactory(HeaderFactory factory) {
        this.headerFactory = factory;
    }

    public static interface HeaderFactory {
        public Element getHeader(SoapVersion var1);
    }
}

