/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.wsdl11.SoapAddressPlugin;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapTransportFactory
extends AbstractTransportFactory
implements DestinationFactory,
WSDLEndpointFactory,
ConduitInitiator {
    public static final String SOAP_11_HTTP_BINDING = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP_12_HTTP_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    public static final String TRANSPORT_ID = "http://schemas.xmlsoap.org/soap/";
    private Bus bus;
    private Collection<String> activationNamespaces;

    public Destination getDestination(EndpointInfo ei) throws IOException {
        SoapBindingInfo binding = (SoapBindingInfo)ei.getBinding();
        try {
            DestinationFactory destinationFactory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(binding.getTransportURI());
            return destinationFactory.getDestination(ei);
        }
        catch (BusException e) {
            throw new RuntimeException("Could not find destination factory for transport " + binding.getTransportURI());
        }
    }

    public void createPortExtensors(EndpointInfo ei, Service service) {
        if (ei.getBinding() instanceof SoapBindingInfo) {
            SoapBindingInfo bi = (SoapBindingInfo)ei.getBinding();
            this.createSoapExtensors(ei, bi, bi.getSoapVersion() instanceof Soap12);
        }
    }

    private void createSoapExtensors(EndpointInfo ei, SoapBindingInfo bi, boolean isSoap12) {
        try {
            ExtensionRegistry extensionRegistry = WSDLFactory.newInstance().newPopulatedExtensionRegistry();
            SoapAddressPlugin addresser = new SoapAddressPlugin();
            addresser.setExtensionRegistry(extensionRegistry);
            String address = ei.getAddress();
            if (address == null) {
                address = "http://localhost:9090";
            }
            ei.addExtensor((Object)addresser.createExtension(isSoap12, address));
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
    }

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        String transportURI = "http://schemas.xmlsoap.org/wsdl/soap/";
        if (b instanceof SoapBindingInfo) {
            SoapBindingInfo sbi = (SoapBindingInfo)b;
            transportURI = sbi.getTransportURI();
        }
        if (port != null) {
            List ees = port.getExtensibilityElements();
            for (Object extensor : ees) {
                if (!SOAPBindingUtil.isSOAPAddress(extensor)) continue;
                SoapAddress sa = SOAPBindingUtil.getSoapAddress(extensor);
                SoapEndpointInfo info = new SoapEndpointInfo(serviceInfo, transportURI);
                info.addExtensor(sa);
                info.setAddress(sa.getLocationURI());
                return info;
            }
        }
        return new SoapEndpointInfo(serviceInfo, transportURI);
    }

    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target) throws IOException {
        return this.getConduit(ei);
    }

    public Conduit getConduit(EndpointInfo ei) throws IOException {
        SoapBindingInfo binding = (SoapBindingInfo)ei.getBinding();
        try {
            ConduitInitiator conduitInit = ((ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator(binding.getTransportURI());
            return conduitInit.getConduit(ei);
        }
        catch (BusException e) {
            throw new RuntimeException("Could not find destination factory for transport " + binding.getTransportURI());
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="bus")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @Resource(name="activationNamespaces")
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    void registerWithBindingManager() {
        if (null == this.bus) {
            return;
        }
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        if (null != dfm) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, (DestinationFactory)this);
            }
        }
    }

    private static class SoapEndpointInfo
    extends EndpointInfo {
        SoapAddress saddress;

        SoapEndpointInfo(ServiceInfo serv, String trans) {
            super(serv, trans);
        }

        public void setAddress(String s) {
            super.setAddress(s);
            if (this.saddress != null) {
                this.saddress.setLocationURI(s);
            }
        }

        public void addExtensor(Object el) {
            super.addExtensor(el);
            if (el instanceof SoapAddress) {
                this.saddress = (SoapAddress)el;
            }
        }
    }
}

