/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.util.ArrayList;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;

public abstract class AbstractBuffers
extends AbstractLifeCycle
implements Buffers {
    private static int BUFFER_LOSS_RATE = 256;
    private int _headerBufferSize = 4096;
    private int _requestBufferSize = 8192;
    private int _responseBufferSize = 24576;
    private transient ArrayList _headerBuffers = new ArrayList();
    private transient int _loss;
    private transient ArrayList _requestBuffers;
    private transient ArrayList _responseBuffers;

    public int getHeaderBufferSize() {
        return this._headerBufferSize;
    }

    public void setHeaderBufferSize(int headerBufferSize) {
        this._headerBufferSize = headerBufferSize;
    }

    public int getRequestBufferSize() {
        return this._requestBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this._requestBufferSize = requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this._responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this._responseBufferSize = responseBufferSize;
    }

    protected abstract Buffer newBuffer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBuffer(int size) {
        if (size == this._headerBufferSize) {
            ArrayList arrayList = this._headerBuffers;
            synchronized (arrayList) {
                if (this._headerBuffers.size() > 0) {
                    return (Buffer)this._headerBuffers.remove(this._headerBuffers.size() - 1);
                }
            }
            return this.newBuffer(size);
        }
        if (size == this._responseBufferSize) {
            ArrayList arrayList = this._responseBuffers;
            synchronized (arrayList) {
                if (this._responseBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._responseBuffers.remove(this._responseBuffers.size() - 1);
            }
        }
        if (size == this._requestBufferSize) {
            ArrayList arrayList = this._requestBuffers;
            synchronized (arrayList) {
                if (this._requestBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._requestBuffers.remove(this._requestBuffers.size() - 1);
            }
        }
        return this.newBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (this._loss++ > BUFFER_LOSS_RATE) {
            this._loss = 0;
            return;
        }
        buffer.clear();
        if (!buffer.isVolatile() && !buffer.isImmutable()) {
            int c = buffer.capacity();
            if (c == this._headerBufferSize) {
                ArrayList arrayList = this._headerBuffers;
                synchronized (arrayList) {
                    this._headerBuffers.add(buffer);
                }
            }
            if (c == this._responseBufferSize) {
                ArrayList arrayList = this._responseBuffers;
                synchronized (arrayList) {
                    this._responseBuffers.add(buffer);
                }
            }
            if (c == this._requestBufferSize) {
                ArrayList arrayList = this._requestBuffers;
                synchronized (arrayList) {
                    this._requestBuffers.add(buffer);
                }
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._headerBuffers != null) {
            this._headerBuffers.clear();
        } else {
            this._headerBuffers = new ArrayList();
        }
        if (this._requestBuffers != null) {
            this._requestBuffers.clear();
        } else {
            this._requestBuffers = new ArrayList();
        }
        if (this._responseBuffers != null) {
            this._responseBuffers.clear();
        } else {
            this._responseBuffers = new ArrayList();
        }
    }
}

