/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.logical;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.jaxws.handler.logical.LogicalMessageContextImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;

public class LogicalMessageImpl
implements LogicalMessage {
    private final LogicalMessageContextImpl msgContext;

    public LogicalMessageImpl(LogicalMessageContextImpl lmctx) {
        this.msgContext = lmctx;
    }

    public Source getPayload() {
        Source source = (Source)this.msgContext.getWrappedMessage().getContent(Source.class);
        if (source == null) {
            SOAPMessage msg = (SOAPMessage)this.msgContext.getWrappedMessage().getContent(SOAPMessage.class);
            XMLStreamReader reader = null;
            if (msg != null) {
                try {
                    source = new DOMSource(msg.getSOAPBody().getFirstChild());
                    reader = StaxUtils.createXMLStreamReader((Source)source);
                }
                catch (SOAPException e) {
                    // empty catch block
                }
            }
            if (source == null) {
                try {
                    W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                    reader = (XMLStreamReader)this.msgContext.getWrappedMessage().getContent(XMLStreamReader.class);
                    StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
                    source = new DOMSource(writer.getDocument().getDocumentElement());
                    reader = StaxUtils.createXMLStreamReader((Document)writer.getDocument());
                }
                catch (ParserConfigurationException e) {
                    throw new WebServiceException((Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            this.msgContext.getWrappedMessage().setContent(XMLStreamReader.class, reader);
            this.msgContext.getWrappedMessage().setContent(Source.class, (Object)source);
        } else if (!(source instanceof DOMSource)) {
            W3CDOMStreamWriter writer;
            try {
                writer = new W3CDOMStreamWriter();
            }
            catch (ParserConfigurationException e) {
                throw new WebServiceException((Throwable)e);
            }
            XMLStreamReader reader = (XMLStreamReader)this.msgContext.getWrappedMessage().getContent(XMLStreamReader.class);
            if (reader == null) {
                reader = StaxUtils.createXMLStreamReader((Source)source);
            }
            try {
                StaxUtils.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
            source = new DOMSource(writer.getDocument().getDocumentElement());
            reader = StaxUtils.createXMLStreamReader((Document)writer.getDocument());
            this.msgContext.getWrappedMessage().setContent(XMLStreamReader.class, (Object)reader);
            this.msgContext.getWrappedMessage().setContent(Source.class, (Object)source);
        }
        return source;
    }

    public void setPayload(Source s) {
        this.msgContext.getWrappedMessage().setContent(Source.class, (Object)s);
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)s);
        this.msgContext.getWrappedMessage().setContent(XMLStreamReader.class, (Object)reader);
    }

    public Object getPayload(JAXBContext arg0) {
        try {
            return arg0.createUnmarshaller().unmarshal(this.getPayload());
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public void setPayload(Object arg0, JAXBContext arg1) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            arg1.createMarshaller().marshal(arg0, (XMLStreamWriter)writer);
            DOMSource source = new DOMSource(writer.getDocument().getDocumentElement());
            this.setPayload(source);
        }
        catch (ParserConfigurationException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

