/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContextImpl
extends WrappedMessageContext
implements SOAPMessageContext {
    private static final SAAJInInterceptor SAAJ_IN = new SAAJInInterceptor();
    private Set<String> roles = new HashSet<String>();

    public SOAPMessageContextImpl(Message m) {
        super(m, MessageContext.Scope.HANDLER);
        this.roles.add(this.getWrappedSoapMessage().getVersion().getNextRole());
    }

    public void setMessage(SOAPMessage message) {
        this.getWrappedMessage().setContent(SOAPMessage.class, (Object)message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SOAPMessage getMessage() {
        Object obj;
        SOAPMessage message = (SOAPMessage)this.getWrappedMessage().getContent(SOAPMessage.class);
        if (null != message) return message;
        Boolean outboundProperty = (Boolean)this.get("javax.xml.ws.handler.message.outbound");
        if (outboundProperty != false) return message;
        if (this.getWrappedMessage().getContent(Object.class) != null) {
            obj = this.getWrappedMessage().getContent(Object.class);
            if (obj instanceof SOAPMessage) {
                return (SOAPMessage)obj;
            }
            if (obj instanceof SOAPBody) {
                return message;
            }
        } else {
            SAAJ_IN.handleMessage(this.getWrappedSoapMessage());
            return (SOAPMessage)this.getWrappedSoapMessage().getContent(SOAPMessage.class);
        }
        if (!(obj instanceof XMLMessage)) return message;
        return message;
    }

    public Object[] getHeaders(QName name, JAXBContext context, boolean allRoles) {
        SOAPMessage msg = this.getMessage();
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null || !header.hasChildNodes()) {
                return new Object[0];
            }
            ArrayList<Object> ret = new ArrayList<Object>();
            Iterator it = CastUtils.cast((Iterator)header.examineAllHeaderElements());
            while (it.hasNext()) {
                SOAPHeaderElement she = (SOAPHeaderElement)it.next();
                if (!allRoles && !this.roles.contains(she.getActor()) || !name.equals(she.getElementQName())) continue;
                ret.add(context.createUnmarshaller().unmarshal((Node)she));
            }
            return ret.toArray(new SOAPHeaderElement[ret.size()]);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    private SoapMessage getWrappedSoapMessage() {
        return (SoapMessage)this.getWrappedMessage();
    }
}

