/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.util.List;
import javax.xml.ws.Holder;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolderInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String CLIENT_HOLDERS = "client.holders";

    public HolderInInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        List inObjects = CastUtils.cast((List)((List)message.getContent(List.class)));
        Exchange exchange = message.getExchange();
        OperationInfo op = (OperationInfo)exchange.get(OperationInfo.class);
        if (op == null || !op.hasOutput() || op.getOutput().size() == 0) {
            return;
        }
        List parts = op.getOutput().getMessageParts();
        boolean client = Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
        if (client) {
            int holderIdx = 0;
            int partIdx = 0;
            for (MessagePartInfo part : parts) {
                if (part.getIndex() != -1) continue;
                ++partIdx;
                break;
            }
            List holders = CastUtils.cast((List)((List)exchange.get((Object)CLIENT_HOLDERS)));
            for (MessagePartInfo part : parts) {
                int idx = part.getIndex();
                if (idx < 0) continue;
                Holder holder = (Holder)holders.get(holderIdx);
                holder.value = inObjects.get(partIdx);
                ++holderIdx;
                ++partIdx;
            }
        } else {
            for (MessagePartInfo part : parts) {
                int idx = part.getIndex();
                if (idx < 0) continue;
                if (part.getProperty("messagepart.mode.inout") != null) {
                    Object object = inObjects.get(idx);
                    inObjects.set(idx, new Holder(object));
                    continue;
                }
                inObjects.add(idx, new Holder());
            }
        }
    }
}

