/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.util.List;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

public class SwAInInterceptor
extends AbstractSoapInterceptor {
    public SwAInInterceptor() {
        super("pre-invoke");
        this.getBefore().add(HolderInInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        boolean client;
        BindingMessageInfo bmi;
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop == null) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor((Message)message)) ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            return;
        }
        SoapBodyInfo sbi = (SoapBodyInfo)bmi.getExtensor(SoapBodyInfo.class);
        if (sbi == null || sbi.getAttachments() == null || sbi.getAttachments().size() == 0) {
            return;
        }
        List inObjects = CastUtils.cast((List)((List)message.getContent(List.class)));
        for (MessagePartInfo mpi : sbi.getAttachments()) {
            String partName = mpi.getConcreteName().getLocalPart();
            String start = partName + "=";
            boolean found = false;
            int idx = mpi.getMessageInfo().getMessagePartIndex(mpi);
            while (idx >= inObjects.size()) {
                inObjects.add(null);
            }
            if (inObjects.get(idx) != null) continue;
            for (Attachment a : message.getAttachments()) {
                if (!a.getId().startsWith(start)) continue;
                DataHandler dh = a.getDataHandler();
                String ct = dh.getContentType();
                Object o = null;
                if (DataHandler.class.isAssignableFrom(mpi.getTypeClass())) {
                    o = dh;
                } else if (ct.startsWith("image/")) {
                    try {
                        o = ImageIO.read(dh.getInputStream());
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (ct.startsWith("text/xml") || ct.startsWith("application/xml")) {
                    try {
                        o = new StreamSource(dh.getInputStream());
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    o = dh;
                }
                inObjects.set(idx, o);
                found = true;
                break;
            }
            if (found) continue;
            inObjects.add(idx, null);
        }
    }
}

