/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.WrapperHelper;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(WrapperClassInInterceptor.class.getName());

    public WrapperClassInInterceptor() {
        super("post-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Class<?> retType;
        Exchange ex = message.getExchange();
        BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        if (boi == null) {
            return;
        }
        Method method = (Method)ex.get(Method.class);
        if (method != null && method.getName().endsWith("Async") && ((retType = method.getReturnType()).getName().equals("java.util.concurrent.Future") || retType.getName().equals("javax.xml.ws.Response"))) {
            return;
        }
        if (boi != null && boi.isUnwrappedCapable()) {
            BindingMessageInfo bmi;
            MessageInfo messageInfo;
            BindingOperationInfo boi2 = boi.getUnwrappedOperation();
            OperationInfo op = boi2.getOperationInfo();
            MessageInfo wrappedMessageInfo = (MessageInfo)message.get(MessageInfo.class);
            if (wrappedMessageInfo == boi.getOperationInfo().getInput()) {
                messageInfo = op.getInput();
                bmi = boi2.getInput();
            } else {
                messageInfo = op.getOutput();
                bmi = boi2.getOutput();
            }
            List lst = (List)message.getContent(List.class);
            if (lst == null) {
                return;
            }
            Class wrapperClass = null;
            Object wrappedObject = null;
            if (wrappedMessageInfo != null) {
                block2: for (MessagePartInfo part : wrappedMessageInfo.getMessageParts()) {
                    if (messageInfo.getMessagePart(part.getName()) != null) continue;
                    wrapperClass = part.getTypeClass();
                    for (Object o : lst) {
                        if (!wrapperClass.isInstance(o)) continue;
                        wrappedObject = o;
                        break block2;
                    }
                }
            }
            if (lst != null) {
                message.put(MessageInfo.class, (Object)messageInfo);
                message.put(BindingMessageInfo.class, (Object)bmi);
                ex.put(BindingOperationInfo.class, (Object)boi2);
                ex.put(OperationInfo.class, (Object)op);
            }
            if (this.isGET(message)) {
                LOG.info("WrapperClassInInterceptor skipped in HTTP GET method");
                return;
            }
            if (wrapperClass == null || wrappedObject == null) {
                return;
            }
            ArrayList<Object> newParams = new ArrayList<Object>();
            for (MessagePartInfo part : messageInfo.getMessageParts()) {
                if (wrappedMessageInfo.getMessagePart(part.getName()) != null) {
                    newParams.add(lst.get(part.getIndex()));
                    continue;
                }
                try {
                    Object elementType = null;
                    elementType = part.isElement() ? part.getElementQName().getLocalPart() : (part.getTypeQName() == null ? null : part.getTypeQName().getLocalPart());
                    Object obj = WrapperHelper.getWrappedPart((String)part.getName().getLocalPart(), wrappedObject, (String)elementType);
                    newParams.add(obj);
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
            message.setContent(List.class, newParams);
        }
    }
}

