/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPDestination
extends AbstractMultiplexDestination
implements Configurable,
Assertor {
    public static final String HTTP_REQUEST = "HTTP.REQUEST";
    public static final String HTTP_RESPONSE = "HTTP.RESPONSE";
    public static final String HTTP_CONTEXT = "HTTP.CONTEXT";
    public static final String PROTOCOL_HEADERS_CONTENT_TYPE = "Content-Type".toLowerCase();
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    private static final long serialVersionUID = 1L;
    protected final Bus bus;
    protected final ConduitInitiator conduitInitiator;
    protected HTTPServerPolicy server;
    protected String contextMatchStrategy = "stem";
    protected boolean fixedParameterOrder;
    protected boolean multiplexWithAddress;

    public AbstractHTTPDestination(Bus b, ConduitInitiator ci, EndpointInfo ei, boolean dp) throws IOException {
        super(b, AbstractHTTPDestination.getTargetReference((EndpointInfo)AbstractHTTPDestination.getAddressValue(ei, dp), (Bus)b), ei);
        this.bus = b;
        this.conduitInitiator = ci;
        this.initConfig();
    }

    protected void setHeaders(Message message) {
        List authorizationLines;
        String credentials;
        String authType;
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        this.copyRequestHeaders(message, requestHeaders);
        message.put((Object)Message.PROTOCOL_HEADERS, requestHeaders);
        if (requestHeaders.containsKey("Authorization") && "Basic".equals(authType = (credentials = (String)(authorizationLines = (List)requestHeaders.get("Authorization")).get(0)).split(" ")[0])) {
            String authEncoded = credentials.split(" ")[1];
            try {
                String authDecoded = new String(Base64Utility.decode((String)authEncoded));
                String[] authInfo = authDecoded.split(":");
                String username = authInfo[0];
                String password = authInfo[1];
                AuthorizationPolicy policy = new AuthorizationPolicy();
                policy.setUserName(username);
                policy.setPassword(password);
                message.put(AuthorizationPolicy.class, (Object)policy);
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
    }

    protected void updateResponseHeaders(Message message) {
        HashMap responseHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (responseHeaders == null) {
            responseHeaders = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
        }
        this.setPolicies(responseHeaders);
    }

    protected final boolean isOneWay(Message message) {
        Exchange ex = message.getExchange();
        return ex == null ? false : ex.isOneWay();
    }

    protected void copyRequestHeaders(Message message, Map<String, List<String>> headers) {
        HttpServletRequest req = (HttpServletRequest)message.get((Object)HTTP_REQUEST);
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            List<Object> values;
            String fname = (String)e.nextElement();
            if (headers.containsKey(fname)) {
                values = headers.get(fname);
            } else {
                values = new ArrayList();
                headers.put(HttpHeaderHelper.getHeaderKey((String)fname), values);
            }
            Enumeration e2 = req.getHeaders(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                values.add(val);
            }
        }
    }

    protected void copyResponseHeaders(Message message, HttpServletResponse response) {
        Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (null != headers) {
            if (!headers.containsKey("Content-Type")) {
                response.setContentType((String)message.get((Object)"Content-Type"));
            }
            for (String header : headers.keySet()) {
                List headerList = (List)headers.get(header);
                for (Object value : headerList) {
                    response.addHeader(header, (String)value);
                }
            }
        } else {
            response.setContentType((String)message.get((Object)"Content-Type"));
        }
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei) {
        return AbstractHTTPDestination.getAddressValue(ei, true);
    }

    protected static EndpointInfo getAddressValue(EndpointInfo ei, boolean dp) {
        String addr;
        if (dp && (addr = StringUtils.addDefaultPortIfMissing((String)ei.getAddress())) != null) {
            ei.setAddress(addr);
        }
        return ei;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        HttpServletResponse response = (HttpServletResponse)inMessage.get((Object)HTTP_RESPONSE);
        return new BackChannelConduit(response);
    }

    protected boolean markPartialResponse(Message partialResponse, EndpointReferenceType decoupledTarget) {
        partialResponse.put((Object)Message.RESPONSE_CODE, (Object)202);
        partialResponse.getExchange().put(EndpointReferenceType.class, (Object)decoupledTarget);
        return true;
    }

    private void initConfig() {
        PolicyEngine engine = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        if (null != engine && engine.isEnabled() && null != this.endpointInfo.getService()) {
            this.server = PolicyUtils.getServer(engine, this.endpointInfo, (Destination)this);
        }
        if (null == this.server) {
            this.server = (HTTPServerPolicy)((Object)this.endpointInfo.getTraversedExtensor((Object)new HTTPServerPolicy(), HTTPServerPolicy.class));
        }
    }

    void setPolicies(Map<String, List<String>> headers) {
        HTTPServerPolicy policy = this.server;
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", Arrays.asList(policy.getCacheControl().value()));
        }
        if (policy.isSetContentLocation()) {
            headers.put("Content-Location", Arrays.asList(policy.getContentLocation()));
        }
        if (policy.isSetContentEncoding()) {
            headers.put("Content-Encoding", Arrays.asList(policy.getContentEncoding()));
        }
        if (policy.isSetContentType()) {
            headers.put("Content-Type", Arrays.asList(policy.getContentType()));
        }
        if (policy.isSetServerType()) {
            headers.put("Server", Arrays.asList(policy.getServerType()));
        }
        if (policy.isSetHonorKeepAlive() && !policy.isHonorKeepAlive()) {
            headers.put("Connection", Arrays.asList("close"));
        }
    }

    protected OutputStream flushHeaders(Message outMessage) throws IOException {
        this.updateResponseHeaders(outMessage);
        Object responseObj = outMessage.get((Object)HTTP_RESPONSE);
        ServletOutputStream responseStream = null;
        boolean oneWay = this.isOneWay(outMessage);
        if (responseObj instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)responseObj;
            Integer i = (Integer)outMessage.get((Object)Message.RESPONSE_CODE);
            if (i != null) {
                Map pHeaders;
                int status = i;
                if (500 == i && null != (pHeaders = CastUtils.cast((Map)((Map)outMessage.get((Object)Message.PROTOCOL_HEADERS)))) && pHeaders.containsKey(PROTOCOL_HEADERS_CONTENT_TYPE)) {
                    pHeaders.remove(PROTOCOL_HEADERS_CONTENT_TYPE);
                }
                response.setStatus(status);
            } else {
                response.setStatus(200);
            }
            this.copyResponseHeaders(outMessage, response);
            responseStream = response.getOutputStream();
            if (oneWay) {
                response.flushBuffer();
            }
        } else {
            if (null != responseObj) {
                String m = new org.apache.cxf.common.i18n.Message("UNEXPECTED_RESPONSE_TYPE_MSG", LOG, new Object[]{responseObj.getClass()}).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            String m = new org.apache.cxf.common.i18n.Message("NULL_RESPONSE_MSG", LOG, new Object[0]).toString();
            LOG.log(Level.WARNING, m);
            throw new IOException(m);
        }
        if (oneWay) {
            outMessage.remove((Object)HTTP_RESPONSE);
        }
        return responseStream;
    }

    protected boolean contextMatchOnExact() {
        return "exact".equals(this.contextMatchStrategy);
    }

    public String getBeanName() {
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        return beanName;
    }

    public EndpointReferenceType getAddressWithId(String id) {
        EndpointReferenceType ref = null;
        if (this.isMultiplexWithAddress()) {
            String address = EndpointReferenceUtils.getAddress((EndpointReferenceType)this.reference);
            ref = EndpointReferenceUtils.duplicate((EndpointReferenceType)this.reference);
            if (address.endsWith("/")) {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + id));
            } else {
                EndpointReferenceUtils.setAddress((EndpointReferenceType)ref, (String)(address + "/" + id));
            }
        } else {
            ref = super.getAddressWithId(id);
        }
        return ref;
    }

    public String getId(Map context) {
        String id = null;
        if (this.isMultiplexWithAddress()) {
            String address = (String)context.get(Message.PATH_INFO);
            if (null != address) {
                int afterLastSlashIndex = address.lastIndexOf("/") + 1;
                if (afterLastSlashIndex > 0 && afterLastSlashIndex < address.length()) {
                    id = address.substring(afterLastSlashIndex);
                }
            } else {
                this.getLogger().log(Level.WARNING, new org.apache.cxf.common.i18n.Message("MISSING_PATH_INFO", LOG, new Object[0]).toString());
            }
        } else {
            return super.getId(context);
        }
        return id;
    }

    public String getContextMatchStrategy() {
        return this.contextMatchStrategy;
    }

    public void setContextMatchStrategy(String contextMatchStrategy) {
        this.contextMatchStrategy = contextMatchStrategy;
    }

    public boolean isFixedParameterOrder() {
        return this.fixedParameterOrder;
    }

    public void setFixedParameterOrder(boolean fixedParameterOrder) {
        this.fixedParameterOrder = fixedParameterOrder;
    }

    public boolean isMultiplexWithAddress() {
        return this.multiplexWithAddress;
    }

    public void setMultiplexWithAddress(boolean multiplexWithAddress) {
        this.multiplexWithAddress = multiplexWithAddress;
    }

    public HTTPServerPolicy getServer() {
        return this.server;
    }

    public void setServer(HTTPServerPolicy server) {
        this.server = server;
    }

    public void assertMessage(Message message) {
        PolicyUtils.assertServerPolicy(message, this.server);
    }

    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPSERVERPOLICY_ASSERTION_QNAME.equals(type);
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        protected HttpServletResponse response;
        private Message outMessage;

        WrappedOutputStream(Message m, HttpServletResponse resp) {
            this.outMessage = m;
            this.response = resp;
        }

        protected void onFirstWrite() throws IOException {
            OutputStream responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage);
            if (null != responseStream) {
                this.wrappedStream = responseStream;
            }
        }

        public void close() throws IOException {
            OutputStream responseStream;
            if (this.wrappedStream == null && null != (responseStream = AbstractHTTPDestination.this.flushHeaders(this.outMessage))) {
                this.wrappedStream = responseStream;
            }
            this.commitResponse();
        }

        private void commitResponse() {
            try {
                this.response.flushBuffer();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class BackChannelConduit
    extends AbstractDestination.AbstractBackChannelConduit {
        protected HttpServletResponse response;

        BackChannelConduit(HttpServletResponse resp) {
            super((AbstractDestination)AbstractHTTPDestination.this);
            this.response = resp;
        }

        public void prepare(Message message) throws IOException {
            message.put((Object)AbstractHTTPDestination.HTTP_RESPONSE, (Object)this.response);
            message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, this.response));
        }
    }
}

