/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.apache.cxf.transport.http.HttpBasicAuthSupplier;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.geronimo.mail.util.StringBufferOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConduit
extends AbstractConduit
implements Configurable,
Assertor {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    private static final String KEY_VISITED_URLS = "VisitedURLs";
    private static final String KEY_AUTH_URLS = "AuthURLs";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
    private static final String SC_HTTP_CONDUIT_SUFFIX = ".http-conduit";
    protected HttpURLConnectionFactory connectionFactory;
    private final Bus bus;
    private final EndpointInfo endpointInfo;
    private final String defaultEndpointAddress;
    private URL defaultEndpointURL;
    private Destination decoupledDestination;
    private MessageObserver decoupledObserver;
    private int decoupledDestinationRefCount;
    private HTTPClientPolicy clientSidePolicy;
    private AuthorizationPolicy authorizationPolicy;
    private ProxyAuthorizationPolicy proxyAuthorizationPolicy;
    private TLSClientParameters tlsClientParameters;
    private MessageTrustDecider trustDecider;
    private HttpBasicAuthSupplier basicAuthSupplier;
    private boolean configFinalized;
    private String sessionId;
    private boolean maintainSession;

    public HTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        this(b, ei, null);
    }

    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(HTTPConduit.getTargetReference((EndpointInfo)ei, (EndpointReferenceType)t, (Bus)b));
        this.bus = b;
        this.endpointInfo = ei;
        this.defaultEndpointAddress = t == null ? ei.getAddress() : t.getAddress().getValue();
        this.initializeConfig();
    }

    protected Logger getLogger() {
        return LOG;
    }

    public final String getConduitName() {
        return this.endpointInfo.getName() + SC_HTTP_CONDUIT_SUFFIX;
    }

    private void initializeConfig() {
        PolicyEngine pe = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        if (null != pe && pe.isEnabled() && this.endpointInfo.getService() != null) {
            this.clientSidePolicy = PolicyUtils.getClient(pe, this.endpointInfo, (Conduit)this);
        }
    }

    void finalizeConfig() {
        if (this.clientSidePolicy == null) {
            this.clientSidePolicy = (HTTPClientPolicy)((Object)this.endpointInfo.getTraversedExtensor((Object)new HTTPClientPolicy(), HTTPClientPolicy.class));
        }
        if (this.authorizationPolicy == null) {
            this.authorizationPolicy = (AuthorizationPolicy)this.endpointInfo.getTraversedExtensor((Object)new AuthorizationPolicy(), AuthorizationPolicy.class);
        }
        if (this.proxyAuthorizationPolicy == null) {
            this.proxyAuthorizationPolicy = (ProxyAuthorizationPolicy)this.endpointInfo.getTraversedExtensor((Object)new ProxyAuthorizationPolicy(), ProxyAuthorizationPolicy.class);
        }
        if (this.tlsClientParameters == null) {
            this.tlsClientParameters = (TLSClientParameters)this.endpointInfo.getTraversedExtensor(null, TLSClientParameters.class);
        }
        if (this.trustDecider == null) {
            this.trustDecider = (MessageTrustDecider)this.endpointInfo.getTraversedExtensor(null, MessageTrustDecider.class);
        }
        if (this.basicAuthSupplier == null) {
            this.basicAuthSupplier = (HttpBasicAuthSupplier)this.endpointInfo.getTraversedExtensor(null, HttpBasicAuthSupplier.class);
        }
        if (this.trustDecider == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No Trust Decider configured for Conduit '" + this.getConduitName() + "'");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Message Trust Decider of class '" + this.trustDecider.getClass().getName() + "' with logical name of '" + this.trustDecider.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.basicAuthSupplier == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No Basic Auth Supplier configured for Conduit '" + this.getConduitName() + "'");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "HttpBasicAuthSupplier of class '" + this.basicAuthSupplier.getClass().getName() + "' with logical name of '" + this.basicAuthSupplier.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.tlsClientParameters != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for TLS " + "keyManagers " + this.tlsClientParameters.getKeyManagers() + "trustManagers " + this.tlsClientParameters.getTrustManagers() + "secureRandom " + this.tlsClientParameters.getSecureRandom());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for plain http.");
        }
        this.retrieveConnectionFactory();
        this.configFinalized = true;
    }

    protected void retrieveConnectionFactory() {
        this.connectionFactory = AbstractHTTPTransportFactory.getConnectionFactory(this);
    }

    public void prepare(Message message) throws IOException {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        URL currentURL = this.setupURL(message);
        HttpBasicAuthSupplier.UserPass userPass = null;
        boolean needToCacheRequest = false;
        HttpURLConnection connection = this.connectionFactory.createConnection(this.getProxy(this.clientSidePolicy), currentURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)this.clientSidePolicy.getConnectionTimeout());
        connection.setReadTimeout((int)this.clientSidePolicy.getReceiveTimeout());
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        if (null != httpRequestMethod) {
            connection.setRequestMethod(httpRequestMethod);
        } else {
            connection.setRequestMethod("POST");
        }
        if (this.basicAuthSupplier != null) {
            userPass = this.basicAuthSupplier.getPreemptiveUserPass(this.getConduitName(), currentURL, message);
            needToCacheRequest = userPass == null;
            LOG.log(Level.INFO, "Basic Auth Supplier, but no Premeptive User Pass. We must cache request.");
        }
        if (this.getClient().isAutoRedirect()) {
            needToCacheRequest = true;
            LOG.log(Level.INFO, "AutoRedirect is turned on.");
        } else if (!connection.getRequestMethod().equals("GET") && this.getClient().isAllowChunking() && !needToCacheRequest) {
            LOG.log(Level.FINER, "Chunking is set at 2048.");
            connection.setChunkedStreamingMode(2048);
        }
        this.maintainSession = Boolean.TRUE.equals((Boolean)message.get((Object)Message.MAINTAIN_SESSION));
        if (this.maintainSession && this.sessionId != null) {
            connection.setRequestProperty("Cookie", "JSESSIONID=" + this.sessionId);
        }
        message.put((Object)KEY_HTTP_CONNECTION, (Object)connection);
        this.setHeadersByPolicy(message, currentURL, headers);
        message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message, connection, needToCacheRequest));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeTrustDecision(Message message) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get((Object)KEY_HTTP_CONNECTION);
        if (this.trustDecider != null) {
            try {
                connection.connect();
                this.trustDecider.establishTrust(this.getConduitName(), this.connectionFactory.getConnectionInfo(connection), message);
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.log(Level.FINE, "Trust Decider " + this.trustDecider.getLogicalName() + " considers Conduit " + this.getConduitName() + " trusted.");
                return;
            }
            catch (UntrustedURLConnectionIOException untrustedEx) {
                connection.disconnect();
                if (!LOG.isLoggable(Level.INFO)) throw untrustedEx;
                LOG.log(Level.INFO, "Trust Decider " + this.trustDecider.getLogicalName() + " considers Conduit " + this.getConduitName() + " untrusted.", untrustedEx);
                throw untrustedEx;
            }
        } else {
            if (!LOG.isLoggable(Level.FINE)) return;
            LOG.log(Level.FINE, "No Trust Decider for Conduit '" + this.getConduitName() + "'. An afirmative Trust Decision is assumed.");
        }
    }

    private URL setupURL(Message message) throws MalformedURLException {
        String result;
        String value = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)Message.PATH_INFO);
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        String string = result = value != null ? value : this.getURL().toString();
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return new URL(result);
    }

    public synchronized Destination getBackChannel() {
        if (this.decoupledDestination == null && this.getClient().getDecoupledEndpoint() != null) {
            this.setUpDecoupledDestination();
        }
        return this.decoupledDestination;
    }

    public void close() {
        if (this.defaultEndpointURL != null) {
            try {
                URLConnection connect = this.defaultEndpointURL.openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.decoupledDestination != null) {
            this.releaseDecoupledDestination();
        }
    }

    protected String getAddress() throws MalformedURLException {
        return this.defaultEndpointAddress;
    }

    protected synchronized URL getURL() throws MalformedURLException {
        return this.getURL(true);
    }

    protected synchronized URL getURL(boolean createOnDemand) throws MalformedURLException {
        if (this.defaultEndpointURL == null && createOnDemand) {
            this.defaultEndpointURL = new URL(this.defaultEndpointAddress);
        }
        return this.defaultEndpointURL;
    }

    private Map<String, List<String>> getSetProtocolHeaders(Message message) {
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (null == headers) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }

    private void transferProtocolHeadersToURLConnection(Message message, URLConnection connection) {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        for (String header : headers.keySet()) {
            List<String> headerList = headers.get(header);
            for (String value : headerList) {
                connection.addRequestProperty(header, value);
            }
        }
    }

    private void logProtocolHeaders(Level level, Message message) {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        for (String header : headers.keySet()) {
            List<String> headerList = headers.get(header);
            for (String value : headerList) {
                LOG.log(level, header + ": " + value);
            }
        }
    }

    private void setURLRequestHeaders(Message message) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get((Object)KEY_HTTP_CONNECTION);
        String ct = (String)message.get((Object)"Content-Type");
        String enc = (String)message.get((Object)Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1) {
                ct = ct + "; charset=" + enc;
            }
            connection.setRequestProperty("Content-Type", ct);
        } else if (enc != null) {
            connection.setRequestProperty("Content-Type", "text/xml; charset=" + enc);
        } else {
            connection.setRequestProperty("Content-Type", "text/xml");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + connection.getRequestMethod() + " Message with Headers to " + connection.getURL() + " Conduit :" + this.getConduitName());
            this.logProtocolHeaders(Level.FINE, message);
        }
        this.transferProtocolHeadersToURLConnection(message, connection);
    }

    private void setUpDecoupledDestination() {
        EndpointReferenceType reference = EndpointReferenceUtils.getEndpointReference((String)this.getClient().getDecoupledEndpoint());
        if (reference != null) {
            String decoupledAddress = reference.getAddress().getValue();
            LOG.info("creating decoupled endpoint: " + decoupledAddress);
            try {
                this.decoupledDestination = this.getDestination(decoupledAddress);
                this.duplicateDecoupledDestination();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "decoupled endpoint creation failed: ", e);
            }
        }
    }

    private Destination getDestination(String address) throws IOException {
        Destination destination = null;
        DestinationFactoryManager factoryManager = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory factory = factoryManager.getDestinationFactoryForUri(address);
        if (factory != null) {
            EndpointInfo ei = new EndpointInfo();
            ei.setAddress(address);
            destination = factory.getDestination(ei);
            this.decoupledObserver = new InterposedMessageObserver();
            destination.setMessageObserver(this.decoupledObserver);
        }
        return destination;
    }

    protected MessageObserver getDecoupledObserver() {
        return this.decoupledObserver;
    }

    private synchronized void duplicateDecoupledDestination() {
        ++this.decoupledDestinationRefCount;
    }

    private synchronized void releaseDecoupledDestination() {
        if (--this.decoupledDestinationRefCount == 0) {
            LOG.log(Level.INFO, "shutting down decoupled destination");
            this.decoupledDestination.shutdown();
        }
    }

    private boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    private boolean isPartialResponse(HttpURLConnection connection, int responseCode) {
        return responseCode == 202 && connection.getContentLength() != 0;
    }

    private Proxy getProxy(HTTPClientPolicy policy) {
        Proxy proxy = null;
        if (policy != null && policy.isSetProxyServer()) {
            proxy = new Proxy(Proxy.Type.valueOf(policy.getProxyServerType().toString()), new InetSocketAddress(policy.getProxyServer(), policy.getProxyServerPort()));
        }
        return proxy;
    }

    private void setHeadersByAuthorizationPolicy(Message message, URL url, Map<String, List<String>> headers) {
        AuthorizationPolicy authPolicy = this.getAuthorization();
        HttpBasicAuthSupplier.UserPass userpass = null;
        if (this.basicAuthSupplier != null) {
            userpass = this.basicAuthSupplier.getPreemptiveUserPass(this.getConduitName(), url, message);
        }
        AuthorizationPolicy newPolicy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        String userName = null;
        String passwd = null;
        if (null != newPolicy) {
            userName = newPolicy.getUserName();
            passwd = newPolicy.getPassword();
        }
        if (userName == null && userpass != null) {
            userName = userpass.getUserid();
            passwd = userpass.getPassword();
        }
        if (userName == null && authPolicy != null && authPolicy.isSetUserName()) {
            userName = authPolicy.getUserName();
        }
        if (userName != null) {
            if (passwd == null && authPolicy != null && authPolicy.isSetPassword()) {
                passwd = authPolicy.getPassword();
            }
            this.setBasicAuthHeader(userName, passwd, headers);
        } else if (authPolicy != null && authPolicy.isSetAuthorizationType() && authPolicy.isSetAuthorization()) {
            String type = authPolicy.getAuthorizationType();
            type = type + " ";
            type = type + authPolicy.getAuthorization();
            headers.put("Authorization", Arrays.asList(type));
        }
        ProxyAuthorizationPolicy proxyAuthPolicy = this.getProxyAuthorization();
        if (proxyAuthPolicy != null && proxyAuthPolicy.isSetUserName()) {
            userName = proxyAuthPolicy.getUserName();
            if (userName != null) {
                passwd = "";
                if (proxyAuthPolicy.isSetPassword()) {
                    passwd = proxyAuthPolicy.getPassword();
                }
                this.setProxyBasicAuthHeader(userName, passwd, headers);
            } else if (proxyAuthPolicy.isSetAuthorizationType() && proxyAuthPolicy.isSetAuthorization()) {
                String type = proxyAuthPolicy.getAuthorizationType();
                type = type + " ";
                type = type + proxyAuthPolicy.getAuthorization();
                headers.put("Proxy-Authorization", Arrays.asList(type));
            }
        }
    }

    private void setHeadersByClientPolicy(Message message, Map<String, List<String>> headers) {
        HTTPClientPolicy policy = this.getClient(message);
        if (policy == null) {
            return;
        }
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", Arrays.asList(policy.getCacheControl().value()));
        }
        if (policy.isSetHost()) {
            headers.put("Host", Arrays.asList(policy.getHost()));
        }
        if (policy.isSetConnection()) {
            headers.put("Connection", Arrays.asList(policy.getConnection().value()));
        }
        if (policy.isSetAccept()) {
            headers.put("Accept", Arrays.asList(policy.getAccept()));
        }
        if (policy.isSetAcceptEncoding()) {
            headers.put("Accept-Encoding", Arrays.asList(policy.getAcceptEncoding()));
        }
        if (policy.isSetAcceptLanguage()) {
            headers.put("Accept-Language", Arrays.asList(policy.getAcceptLanguage()));
        }
        if (policy.isSetContentType()) {
            headers.put("Content-Type", Arrays.asList(policy.getContentType()));
        }
        if (policy.isSetCookie()) {
            headers.put("Cookie", Arrays.asList(policy.getCookie()));
        }
        if (policy.isSetBrowserType()) {
            headers.put("BrowserType", Arrays.asList(policy.getBrowserType()));
        }
        if (policy.isSetReferer()) {
            headers.put("Referer", Arrays.asList(policy.getReferer()));
        }
    }

    private void setHeadersByPolicy(Message message, URL url, Map<String, List<String>> headers) {
        this.setHeadersByAuthorizationPolicy(message, url, headers);
        this.setHeadersByClientPolicy(message, headers);
    }

    public String getBeanName() {
        if (this.endpointInfo.getName() != null) {
            return this.endpointInfo.getName().toString() + SC_HTTP_CONDUIT_SUFFIX;
        }
        return null;
    }

    public AuthorizationPolicy getAuthorization() {
        return this.authorizationPolicy;
    }

    @Resource
    public void setAuthorization(AuthorizationPolicy authorization) {
        this.authorizationPolicy = authorization;
    }

    public HTTPClientPolicy getClient(Message message) {
        return PolicyUtils.getClient(message, this.clientSidePolicy);
    }

    public HTTPClientPolicy getClient() {
        return this.clientSidePolicy;
    }

    @Resource
    public void setClient(HTTPClientPolicy client) {
        this.clientSidePolicy = client;
    }

    public ProxyAuthorizationPolicy getProxyAuthorization() {
        return this.proxyAuthorizationPolicy;
    }

    @Resource
    public void setProxyAuthorization(ProxyAuthorizationPolicy proxyAuthorization) {
        this.proxyAuthorizationPolicy = proxyAuthorization;
    }

    public TLSClientParameters getTlsClientParameters() {
        return this.tlsClientParameters;
    }

    @Resource
    public void setTlsClientParameters(TLSClientParameters params) {
        this.tlsClientParameters = params;
        if (this.tlsClientParameters != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re) configured for TLS " + "keyManagers " + this.tlsClientParameters.getKeyManagers() + "trustManagers " + this.tlsClientParameters.getTrustManagers() + "secureRandom " + this.tlsClientParameters.getSecureRandom());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re)configured for plain http.");
        }
        if (this.configFinalized) {
            this.retrieveConnectionFactory();
        }
    }

    public MessageTrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    @Resource
    public void setTrustDecider(MessageTrustDecider decider) {
        this.trustDecider = decider;
    }

    public HttpBasicAuthSupplier getBasicAuthSupplier() {
        return this.basicAuthSupplier;
    }

    @Resource
    public void setBasicAuthSupplier(HttpBasicAuthSupplier supplier) {
        this.basicAuthSupplier = supplier;
    }

    private HttpURLConnection processRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 301: 
            case 302: {
                connection = this.redirectRetransmit(connection, message, cachedStream);
                break;
            }
            case 401: {
                connection = this.authorizationRetransmit(connection, message, cachedStream);
                break;
            }
        }
        return connection;
    }

    private HttpURLConnection redirectRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (!this.getClient().isAutoRedirect()) {
            return connection;
        }
        Set<String> visitedURLs = this.getSetVisitedURLs(message);
        String lastURL = connection.getURL().toString();
        visitedURLs.add(lastURL);
        String newURL = this.extractLocation(connection.getHeaderFields());
        if (newURL != null) {
            if (visitedURLs.contains(newURL)) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Redirect loop detected on Conduit \"" + this.getConduitName() + "\" on '" + newURL + "'");
                }
                return connection;
            }
            Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
            headers.remove("Authorization");
            headers.remove("Proxy-Authorization");
            URL url = new URL(newURL);
            this.setHeadersByAuthorizationPolicy(message, url, headers);
            connection = this.retransmit(connection, url, message, cachedStream);
        }
        return connection;
    }

    private Set<String> getSetAuthoriationURLs(Message message) {
        HashSet authURLs = (HashSet)message.get((Object)KEY_AUTH_URLS);
        if (authURLs == null) {
            authURLs = new HashSet();
            message.put((Object)KEY_AUTH_URLS, authURLs);
        }
        return authURLs;
    }

    private Set<String> getSetVisitedURLs(Message message) {
        HashSet visitedURLs = (HashSet)message.get((Object)KEY_VISITED_URLS);
        if (visitedURLs == null) {
            visitedURLs = new HashSet();
            message.put((Object)KEY_VISITED_URLS, visitedURLs);
        }
        return visitedURLs;
    }

    private HttpURLConnection authorizationRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (this.basicAuthSupplier == null) {
            return connection;
        }
        URL currentURL = connection.getURL();
        String realm = this.extractAuthorizationRealm(connection.getHeaderFields());
        Set<String> authURLs = this.getSetAuthoriationURLs(message);
        if (authURLs.contains(currentURL.toString() + realm)) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Authorization loop detected on Conduit \"" + this.getConduitName() + "\" on URL \"" + "\" with realm \"" + realm + "\"");
            }
            return connection;
        }
        HttpBasicAuthSupplier.UserPass up = this.basicAuthSupplier.getUserPassForRealm(this.getConduitName(), currentURL, message, realm);
        if (up == null) {
            return connection;
        }
        authURLs.add(currentURL.toString() + realm);
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        this.setBasicAuthHeader(up.getUserid(), up.getPassword(), headers);
        return this.retransmit(connection, currentURL, message, cachedStream);
    }

    private HttpURLConnection retransmit(HttpURLConnection connection, URL newURL, Message message, CacheAndWriteOutputStream stream) throws IOException {
        connection.disconnect();
        connection = this.connectionFactory.createConnection(this.getProxy(this.clientSidePolicy), newURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)this.getClient().getConnectionTimeout());
        connection.setReadTimeout((int)this.getClient().getReceiveTimeout());
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        if (null != httpRequestMethod) {
            connection.setRequestMethod(httpRequestMethod);
        } else {
            connection.setRequestMethod("POST");
        }
        message.put((Object)KEY_HTTP_CONNECTION, (Object)connection);
        this.setURLRequestHeaders(message);
        this.makeTrustDecision(message);
        if (connection.getRequestMethod().equals("GET")) {
            return connection;
        }
        OutputStream out = connection.getOutputStream();
        CacheAndWriteOutputStream.copyStream((InputStream)stream.getInputStream(), (OutputStream)out, (int)2048);
        out.close();
        if (LOG.isLoggable(Level.FINE)) {
            StringBuffer sbuf = new StringBuffer();
            StringBufferOutputStream sout = new StringBufferOutputStream(sbuf);
            CacheAndWriteOutputStream.copyStream((InputStream)stream.getInputStream(), (OutputStream)sout, (int)2048);
            sout.close();
            LOG.fine("Conduit \"" + this.getConduitName() + "\" Retransmit message to: " + connection.getURL() + ": " + sbuf);
        }
        return connection;
    }

    private String extractAuthorizationRealm(Map<String, List<String>> headers) {
        List<String> auth = headers.get("WWW-Authenticate");
        if (auth != null) {
            for (String a : auth) {
                if (!a.startsWith("Basic realm=")) continue;
                return a.substring(a.indexOf("=") + 1);
            }
        }
        return null;
    }

    private String extractLocation(Map<String, List<String>> headers) {
        List<String> locs = headers.get("Location");
        if (locs != null && locs.size() > 0) {
            return locs.get(0);
        }
        return null;
    }

    private void setBasicAuthHeader(String userid, String password, Map<String, List<String>> headers) {
        String userpass = userid;
        userpass = userpass + ":";
        if (password != null) {
            userpass = userpass + password;
        }
        String token = Base64Utility.encode((byte[])userpass.getBytes());
        headers.put("Authorization", Arrays.asList("Basic " + token));
    }

    private void setProxyBasicAuthHeader(String userid, String password, Map<String, List<String>> headers) {
        String userpass = userid;
        userpass = userpass + ":";
        if (password != null) {
            userpass = userpass + password;
        }
        String token = Base64Utility.encode((byte[])userpass.getBytes());
        headers.put("Proxy-Authorization", Arrays.asList("Basic " + token));
    }

    public void assertMessage(Message message) {
        PolicyUtils.assertClientPolicy(message, this.clientSidePolicy);
    }

    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPCLIENTPOLICY_ASSERTION_QNAME.equals(type);
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            HTTPConduit.this.getSetProtocolHeaders(inMessage);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)200);
            inMessage.remove((Object)"HTTP.REQUEST");
            inMessage.remove((Object)"HTTP.RESPONSE");
            inMessage.remove((Object)"org.apache.cxf.async.post.response.dispatch");
            HTTPConduit.this.incomingObserver.onMessage(inMessage);
        }
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        private HttpURLConnection connection;
        private boolean cachingForRetransmision;
        private CacheAndWriteOutputStream cachedStream;
        private Message outMessage;

        WrappedOutputStream(Message m, HttpURLConnection c, boolean possibleRetransmit) {
            this.outMessage = m;
            this.connection = c;
            this.cachingForRetransmision = possibleRetransmit;
        }

        protected void onFirstWrite() throws IOException {
            this.handleHeadersTrustCaching();
        }

        protected void handleHeadersTrustCaching() throws IOException {
            HTTPConduit.this.setURLRequestHeaders(this.outMessage);
            HTTPConduit.this.makeTrustDecision(this.outMessage);
            if (this.connection.getRequestMethod().equals("GET")) {
                return;
            }
            if (this.cachingForRetransmision) {
                this.cachedStream = new CacheAndWriteOutputStream(this.connection.getOutputStream());
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = this.connection.getOutputStream();
            }
        }

        public void close() throws IOException {
            if (!this.written) {
                this.handleHeadersTrustCaching();
            }
            this.handleResponse();
            super.close();
        }

        private void handleRetransmits() throws IOException {
            if (this.cachedStream != null) {
                int maxRetransmits;
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuffer sbuf = new StringBuffer();
                    StringBufferOutputStream sout = new StringBufferOutputStream(sbuf);
                    IOUtils.copy((InputStream)this.cachedStream.getInputStream(), (OutputStream)sout, (int)2048);
                    sout.close();
                    LOG.fine("Conduit \"" + HTTPConduit.this.getConduitName() + "\" Transmit cached message to: " + this.connection.getURL() + ": " + sbuf);
                }
                HttpURLConnection oldcon = this.connection;
                HTTPClientPolicy policy = HTTPConduit.this.getClient();
                int n = maxRetransmits = policy == null ? -1 : policy.getMaxRetransmits();
                if (maxRetransmits == 0) {
                    return;
                }
                int nretransmits = 0;
                this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                while (this.connection != oldcon) {
                    oldcon = this.connection;
                    if (maxRetransmits >= 0 && ++nretransmits >= maxRetransmits) continue;
                    this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                }
            }
        }

        private void handleResponse() throws IOException {
            String cookieStr;
            this.handleRetransmits();
            int responseCode = this.connection.getResponseCode();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Response Code: " + responseCode + " Conduit: " + HTTPConduit.this.getConduitName());
            }
            if (responseCode == 404) {
                throw new IOException(this.connection.getResponseMessage());
            }
            Exchange exchange = this.outMessage.getExchange();
            if (HTTPConduit.this.isOneway(exchange) && !HTTPConduit.this.isPartialResponse(this.connection, responseCode)) {
                this.connection.getInputStream().close();
                return;
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            InputStream in = null;
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (String key : this.connection.getHeaderFields().keySet()) {
                headers.put(HttpHeaderHelper.getHeaderKey((String)key), this.connection.getHeaderFields().get(key));
            }
            inMessage.put((Object)Message.PROTOCOL_HEADERS, headers);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
            inMessage.put((Object)"Content-Type", (Object)this.connection.getHeaderField("Content-Type"));
            if (HTTPConduit.this.maintainSession && (cookieStr = this.connection.getHeaderField("Set-Cookie")) != null) {
                String[] cookies = cookieStr.split(";");
                for (int i = 0; i < cookies.length; ++i) {
                    String[] nameValue = cookies[i].split("=");
                    if (!nameValue[0].equals("JSESSIONID") && !nameValue[0].equals("jsessionid")) continue;
                    HTTPConduit.this.sessionId = nameValue[1];
                }
            }
            if (null == (in = this.connection.getErrorStream())) {
                in = this.connection.getInputStream();
            }
            if (in == null) {
                LOG.log(Level.WARNING, "Input Stream is null!");
            }
            inMessage.setContent(InputStream.class, (Object)in);
            HTTPConduit.this.incomingObserver.onMessage((Message)inMessage);
        }
    }
}

