/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLBuilder;
import org.apache.cxf.wsdl.WSDLExtensibilityPlugin;
import org.apache.cxf.wsdl11.WSDLLocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLDefinitionBuilder
implements WSDLBuilder<Definition> {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLDefinitionBuilder.class);
    private static final String EXTENSIONS_RESOURCE = "META-INF/extensions.xml";
    private static final String WSDL_PLUGIN_RESOURCE = "META-INF/wsdl.plugin.xml";
    protected WSDLReader wsdlReader;
    protected Definition wsdlDefinition;
    final WSDLFactory wsdlFactory;
    final ExtensionRegistry registry;
    private List<Definition> importedDefinitions = new ArrayList<Definition>();
    private final Map<String, WSDLExtensibilityPlugin> wsdlPlugins = new HashMap<String, WSDLExtensibilityPlugin>();

    public WSDLDefinitionBuilder() {
        try {
            this.wsdlFactory = WSDLFactory.newInstance();
            this.registry = this.wsdlFactory.newPopulatedExtensionRegistry();
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            this.registry.registerDeserializer(MIMEPart.class, header, (ExtensionDeserializer)new SOAPHeaderSerializer());
            this.registry.registerSerializer(MIMEPart.class, header, (ExtensionSerializer)new SOAPHeaderSerializer());
            this.registry.mapExtensionTypes(MIMEPart.class, header, SOAPHeaderImpl.class);
            this.registerInitialExtensions();
            this.wsdlReader = this.wsdlFactory.newWSDLReader();
            this.wsdlReader.setFeature("javax.wsdl.verbose", false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WSDLDefinitionBuilder(boolean requirePlugins) {
        this();
        if (requirePlugins) {
            this.registerWSDLExtensibilityPlugins();
        }
    }

    @Override
    public Definition build(String wsdlURL) {
        this.parseWSDL(wsdlURL);
        return this.wsdlDefinition;
    }

    protected void parseWSDL(String wsdlURL) {
        try {
            this.wsdlReader.setExtensionRegistry(this.registry);
            WSDLLocatorImpl wsdlLocator = new WSDLLocatorImpl(wsdlURL);
            this.wsdlDefinition = this.wsdlReader.readWSDL((WSDLLocator)wsdlLocator);
            this.parseImports(this.wsdlDefinition);
        }
        catch (Exception we) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[]{wsdlURL});
            throw new RuntimeException(msg.toString(), we);
        }
    }

    public static Collection<Import> getImports(Definition wsdlDef) {
        ArrayList<Import> importList = new ArrayList<Import>();
        Map imports = wsdlDef.getImports();
        for (String uri : imports.keySet()) {
            List lst = CastUtils.cast((List)((List)imports.get(uri)));
            importList.addAll(lst);
        }
        return importList;
    }

    private void parseImports(Definition def) {
        for (Import impt : WSDLDefinitionBuilder.getImports(def)) {
            this.parseImports(impt.getDefinition());
            this.importedDefinitions.add(impt.getDefinition());
        }
    }

    public List<Definition> getImportedDefinitions() {
        return this.importedDefinitions;
    }

    private void registerInitialExtensions() throws BusException {
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)EXTENSIONS_RESOURCE, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new BusException((Throwable)ex);
        }
        Iterator<Object> it = initialExtensions.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(initialExtensions.getProperty((String)it.next()), "=");
            String parentType = st.nextToken();
            String elementType = st.nextToken();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering extension: " + elementType + " for parent: " + parentType);
                }
                JAXBExtensionHelper.addExtensions((ExtensionRegistry)this.registry, (String)parentType, (String)elementType, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
            catch (JAXBException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
    }

    public ExtensionRegistry getExtenstionRegistry() {
        return this.registry;
    }

    public WSDLFactory getWSDLFactory() {
        return this.wsdlFactory;
    }

    public WSDLReader getWSDLReader() {
        return this.wsdlReader;
    }

    public Map<String, WSDLExtensibilityPlugin> getWSDLPlugins() {
        return this.wsdlPlugins;
    }

    private void registerWSDLExtensibilityPlugins() {
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)WSDL_PLUGIN_RESOURCE, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (String string : initialExtensions.keySet()) {
            String pluginClz = initialExtensions.getProperty(string);
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering : " + pluginClz + " for type: " + string);
                }
                WSDLExtensibilityPlugin plugin = (WSDLExtensibilityPlugin)Class.forName(pluginClz).newInstance();
                plugin.setExtensionRegistry(this.registry);
                this.wsdlPlugins.put(string, plugin);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
    }
}

