/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper;

import javax.xml.ws.Holder;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;

public final class ParameterMapper {
    private ParameterMapper() {
    }

    public static JavaParameter map(MessagePartInfo part, JavaType.Style style, ToolContext context) {
        String name = ProcessorUtil.mangleNameToVariableName(part.getName().getLocalPart());
        String namespace = ProcessorUtil.resolvePartNamespace(part);
        String type = ProcessorUtil.resolvePartType(part, context);
        JavaParameter parameter = new JavaParameter(name, type, namespace);
        parameter.setPartName(part.getName().getLocalPart());
        parameter.setQName(ProcessorUtil.getElementName(part));
        String fullJavaName = ProcessorUtil.getFullClzName(part, context, false);
        parameter.setClassName(fullJavaName);
        if (style == JavaType.Style.INOUT || style == JavaType.Style.OUT) {
            parameter.setHolder(true);
            parameter.setHolderName(Holder.class.getName());
            String holderClass = fullJavaName;
            if (JAXBUtils.holderClass((String)fullJavaName) != null) {
                holderClass = JAXBUtils.holderClass((String)fullJavaName).getName();
            }
            parameter.setHolderClass(holderClass);
        }
        parameter.setStyle(style);
        return parameter;
    }
}

