/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.maven_plugin.jdee;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.util.FileUtils;

/**
 * A super-simple Mojo to emit JDEE project files.
 *
 * @goal clean
 * @description Outputs a JDEE project file.
 * @requiresDependencyResolution test 
 */
public class CleanMojo extends AbstractMojo {
    /**
     * The Maven Project.
     *
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    protected MavenProject project;

    private void cleanPrj() throws Exception {
        FileUtils.delete(new File(project.getBasedir(), "prj.el"));
        FileUtils.delete(new File(project.getBasedir(), ".jdee_sources"));
        FileUtils.delete(new File(project.getBasedir(), ".jdee_classpath"));
    }
    
    public void execute() throws MojoExecutionException {
        try {
            cleanPrj();
        } catch (Exception e) {
            getLog().debug(e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}
