/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.cxf.Bus;
import org.apache.cxf.jca.core.resourceadapter.ResourceBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdapterImpl
extends ResourceBean
implements ResourceAdapter {
    private static final Logger LOG = Logger.getLogger(ResourceAdapterImpl.class.getName());
    private BootstrapContext ctx;
    private Set<Bus> busCache = new HashSet<Bus>();

    public ResourceAdapterImpl() {
        LOG.fine("Resource Adapter is constructed without props");
    }

    public ResourceAdapterImpl(Properties props) {
        super(props);
        LOG.fine("Resource Adapter is constructed with props");
    }

    public void registerBus(Bus bus) {
        LOG.fine("Bus " + bus + " initialized and added to ResourceAdapter busCache");
        this.busCache.add(bus);
    }

    protected Set getBusCache() {
        return this.busCache;
    }

    protected void setBusCache(Set<Bus> cache) {
        this.busCache = cache;
    }

    public void start(BootstrapContext aCtx) throws ResourceAdapterInternalException {
        LOG.fine("Resource Adapter is starting by appserver...");
        if (aCtx == null) {
            throw new ResourceAdapterInternalException("BootstrapContext can not be null");
        }
        this.ctx = aCtx;
    }

    public void stop() {
        LOG.fine("Resource Adapter is stopping by appserver...");
        if (!this.busCache.isEmpty()) {
            Iterator<Bus> busIterator = this.busCache.iterator();
            Bus bus = null;
            while (busIterator.hasNext()) {
                bus = busIterator.next();
                bus.shutdown(true);
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] as) throws ResourceException {
        throw new NotSupportedException();
    }

    public void endpointActivation(MessageEndpointFactory mef, ActivationSpec as) throws ResourceException {
        throw new NotSupportedException();
    }

    public void endpointDeactivation(MessageEndpointFactory mef, ActivationSpec as) {
    }

    public BootstrapContext getBootstrapContext() {
        return this.ctx;
    }
}

