/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding;

import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.wsdl11.WSDLBindingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBindingFactory
implements BindingFactory,
WSDLBindingFactory {
    public static final String DATABINDING_DISABLED = "databinding.disabled";
    Collection<String> activationNamespaces;
    Bus bus;

    @PostConstruct
    void registerWithBindingManager() {
        BindingFactoryManager manager = (BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class);
        for (String ns : this.activationNamespaces) {
            manager.registerBindingFactory(ns, (BindingFactory)this);
        }
    }

    public BindingInfo createBindingInfo(ServiceInfo service, String namespace, Object config) {
        return new BindingInfo(service, namespace);
    }

    public BindingInfo createBindingInfo(Service service, String namespace, Object config) {
        BindingInfo bi = this.createBindingInfo((ServiceInfo)service.getServiceInfos().get(0), namespace, config);
        if (bi.getName() == null) {
            bi.setName(new QName(service.getName().getNamespaceURI(), service.getName().getLocalPart() + "Binding"));
        }
        return bi;
    }

    @Override
    public BindingInfo createBindingInfo(ServiceInfo service, Binding binding, String ns) {
        BindingInfo bi = this.createBindingInfo(service, ns, null);
        return this.initializeBindingInfo(service, binding, bi);
    }

    protected BindingInfo initializeBindingInfo(ServiceInfo service, Binding binding, BindingInfo bi) {
        bi.setName(binding.getQName());
        this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements(), service);
        for (BindingOperation bop : CastUtils.cast((List)binding.getBindingOperations(), BindingOperation.class)) {
            String portTypeNs;
            QName opName;
            BindingOperationInfo bop2;
            String inName = null;
            String outName = null;
            if (bop.getBindingInput() != null) {
                inName = bop.getBindingInput().getName();
            }
            if (bop.getBindingOutput() != null) {
                outName = bop.getBindingOutput().getName();
            }
            if ((bop2 = bi.getOperation(opName = new QName(portTypeNs = binding.getPortType().getQName().getNamespaceURI(), bop.getName()))) == null && (bop2 = bi.buildOperation(opName, inName, outName)) != null) {
                bi.addOperation(bop2);
            }
            if (bop2 == null) continue;
            this.copyExtensors((AbstractPropertiesHolder)bop2, bop.getExtensibilityElements(), service);
            if (bop.getBindingInput() != null) {
                this.copyExtensors((AbstractPropertiesHolder)bop2.getInput(), bop.getBindingInput().getExtensibilityElements(), service);
            }
            if (bop.getBindingOutput() != null) {
                this.copyExtensors((AbstractPropertiesHolder)bop2.getOutput(), bop.getBindingOutput().getExtensibilityElements(), service);
            }
            for (BindingFault f : CastUtils.cast(bop.getBindingFaults().values(), BindingFault.class)) {
                this.copyExtensors((AbstractPropertiesHolder)bop2.getFault(new QName(service.getTargetNamespace(), f.getName())), bop.getBindingFault(f.getName()).getExtensibilityElements(), service);
            }
        }
        return bi;
    }

    private void copyExtensors(AbstractPropertiesHolder info, List<?> extList, ServiceInfo service) {
        if (info != null) {
            for (ExtensibilityElement ext : CastUtils.cast(extList, ExtensibilityElement.class)) {
                info.addExtensor((Object)ext);
                this.addMessageFromBinding(ext, service);
            }
        }
    }

    protected void addMessageFromBinding(ExtensibilityElement ext, ServiceInfo serviceInfo) {
    }

    public void addListener(Destination d, Endpoint e) {
        ChainInitiationObserver observer = new ChainInitiationObserver(e, this.bus);
        d.setMessageObserver((MessageObserver)observer);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="bus")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Collection<String> getActivationNamespaces() {
        return this.activationNamespaces;
    }

    @Resource(name="activationNamespaces")
    public void setActivationNamespaces(Collection<String> activationNamespaces) {
        this.activationNamespaces = activationNamespaces;
    }
}

