/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientFaultConverter
extends AbstractPhaseInterceptor<Message> {
    public ClientFaultConverter() {
        super("unmarshal");
    }

    public ClientFaultConverter(String phase) {
        super(phase);
    }

    public void handleMessage(Message msg) {
        Fault fault = (Fault)msg.getContent(Exception.class);
        if (fault.getDetail() != null) {
            this.processFaultDetail(fault, msg);
            this.setStackTrace(fault, msg);
        }
    }

    protected void processFaultDetail(Fault fault, Message msg) {
        Element exDetail = (Element)DOMUtils.getChild((Node)fault.getDetail(), (int)1);
        QName qname = new QName(exDetail.getNamespaceURI(), exDetail.getLocalName());
        FaultInfo faultWanted = null;
        MessagePartInfo part = null;
        BindingOperationInfo boi = (BindingOperationInfo)msg.getExchange().get(BindingOperationInfo.class);
        if (boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        for (FaultInfo faultInfo : boi.getOperationInfo().getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                if (!qname.equals(mpi.getConcreteName())) continue;
                faultWanted = faultInfo;
                part = mpi;
                break;
            }
            if (faultWanted == null) continue;
            break;
        }
        if (faultWanted == null) {
            return;
        }
        Service s = (Service)msg.getExchange().get(Service.class);
        DataBinding dataBinding = s.getDataBinding();
        DataReader reader = dataBinding.createReader(Node.class);
        Object e = reader.read(part, (Object)exDetail);
        if (!(e instanceof Exception)) {
            Class exClass = (Class)faultWanted.getProperty(Class.class.getName(), Class.class);
            Class<?> beanClass = e.getClass();
            try {
                Constructor constructor = exClass.getConstructor(String.class, beanClass);
                e = constructor.newInstance(fault.getMessage(), e);
            }
            catch (Exception e1) {
                throw new Fault((Throwable)e1);
            }
        }
        msg.setContent(Exception.class, e);
    }

    private void setStackTrace(Fault fault, Message msg) {
        HashMap ns = new HashMap();
        XPathUtils xu = new XPathUtils(ns);
        String ss = (String)xu.getValue("//stackTrace/text()", (Node)fault.getDetail(), XPathConstants.STRING);
        ArrayList<StackTraceElement> stackTraceList = new ArrayList<StackTraceElement>();
        if (StringUtils.isEmpty((String)ss)) {
            StringTokenizer st = new StringTokenizer(ss, "\n");
            while (st.hasMoreTokens()) {
                String oneLine = st.nextToken();
                StringTokenizer stInner = new StringTokenizer(oneLine, "!");
                StackTraceElement ste = new StackTraceElement(stInner.nextToken(), stInner.nextToken(), stInner.nextToken(), Integer.parseInt(stInner.nextToken()));
                stackTraceList.add(ste);
            }
            if (stackTraceList.size() > 0) {
                StackTraceElement[] stackTraceElement = new StackTraceElement[stackTraceList.size()];
                Exception e = (Exception)msg.getContent(Exception.class);
                e.setStackTrace(stackTraceList.toArray(stackTraceElement));
            }
        }
    }
}

