/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.interceptor.WrappedInInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocLiteralInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(DocLiteralInInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(DocLiteralInInterceptor.class);

    public DocLiteralInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
        this.addBefore(WrappedInInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        if (this.isGET(message) && message.getContent(List.class) != null) {
            LOG.info("DocLiteralInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        DataReader<XMLStreamReader> dr = this.getDataReader(message);
        ArrayList<Object> parameters = new ArrayList<Object>();
        Exchange exchange = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        boolean client = this.isRequestor(message);
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader) && bop != null) {
            return;
        }
        if (bop != null && bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        if (bop == null) {
            QName startQName = xmlReader.getName();
            bop = this.getBindingOperationInfo(exchange, startQName, client);
        }
        if (bop != null && bop.isUnwrappedCapable()) {
            ServiceInfo si = bop.getBinding().getService();
            MessageInfo msgInfo = this.setMessage(message, bop, client, si);
            if (((MessagePartInfo)msgInfo.getMessageParts().get(0)).getTypeClass() != null) {
                Object wrappedObject = dr.read((MessagePartInfo)msgInfo.getMessageParts().get(0), (Object)xmlReader);
                parameters.add(wrappedObject);
            } else {
                bop = bop.getUnwrappedOperation();
                msgInfo = this.setMessage(message, bop, client, si);
                List messageParts = msgInfo.getMessageParts();
                Iterator<MessagePartInfo> itr = messageParts.iterator();
                if (xmlReader.getEventType() == 1) {
                    StaxUtils.nextEvent((XMLStreamReader)xmlReader);
                }
                this.getPara(xmlReader, dr, parameters, itr);
            }
        } else {
            BindingMessageInfo msgInfo = null;
            if (bop != null) {
                this.getMessageInfo(message, bop);
                msgInfo = client ? bop.getOutput() : bop.getInput();
            }
            ArrayList<OperationInfo> operations = null;
            operations = new ArrayList<OperationInfo>();
            Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
            ServiceInfo si = ep.getEndpointInfo().getService();
            operations.addAll(si.getInterface().getOperations());
            if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
                for (OperationInfo op : operations) {
                    MessageInfo bmsg = op.getInput();
                    if (bmsg.getMessageParts().size() != 0) continue;
                    BindingOperationInfo boi = ep.getEndpointInfo().getBinding().getOperation(op);
                    exchange.put(BindingOperationInfo.class, (Object)boi);
                    exchange.put(OperationInfo.class, (Object)op);
                    exchange.setOneWay(op.isOneWay());
                }
                return;
            }
            int paramNum = 0;
            do {
                MessagePartInfo p;
                QName elName = xmlReader.getName();
                Object o = null;
                if (!client && msgInfo != null && msgInfo.getMessageParts() != null && msgInfo.getMessageParts().size() == 0) {
                    return;
                }
                if (msgInfo != null && msgInfo.getMessageParts() != null && msgInfo.getMessageParts().size() > 0) {
                    assert (msgInfo.getMessageParts().size() > paramNum);
                    p = (MessagePartInfo)msgInfo.getMessageParts().get(paramNum);
                } else {
                    p = this.findMessagePart(exchange, operations, elName, client, paramNum);
                }
                if (p == null) {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", BUNDLE, new Object[]{elName}), Fault.FAULT_CODE_CLIENT);
                }
                o = dr.read(p, (Object)xmlReader);
                if (o != null) {
                    if (p.getIndex() == -1) {
                        parameters.add(0, o);
                    } else {
                        parameters.add(o);
                    }
                }
                ++paramNum;
            } while (StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader));
        }
        if (parameters.size() > 0) {
            message.setContent(List.class, parameters);
        }
    }

    private void getPara(DepthXMLStreamReader xmlReader, DataReader<XMLStreamReader> dr, List<Object> parameters, Iterator<MessagePartInfo> itr) {
        boolean isListPara = false;
        MessagePartInfo part = null;
        while (StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            Type genericType;
            if (itr.hasNext() && (part = itr.next()).getTypeClass().getName().startsWith("[L") && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType) {
                isListPara = true;
            }
            if (part == null) break;
            Object obj = dr.read(part, (Object)xmlReader);
            if (isListPara) {
                ArrayList<Object> listArg = new ArrayList<Object>();
                for (Object o : (Object[])obj) {
                    listArg.add(o);
                }
                parameters.add(listArg);
                continue;
            }
            parameters.add(obj);
        }
    }

    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor, ServiceInfo si) {
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        message.put(MessageInfo.class, (Object)msgInfo);
        Exchange ex = message.getExchange();
        ex.put(BindingOperationInfo.class, (Object)operation);
        ex.put(OperationInfo.class, (Object)operation.getOperationInfo());
        ex.setOneWay(operation.getOperationInfo().isOneWay());
        message.put((Object)"javax.xml.ws.wsdl.operation", (Object)operation.getName());
        QName serviceQName = si.getName();
        message.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
        QName interfaceQName = si.getInterface().getName();
        message.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
        EndpointInfo endpointInfo = ((Endpoint)ex.get(Endpoint.class)).getEndpointInfo();
        QName portQName = endpointInfo.getName();
        message.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
        URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
        if (wsdlDescription == null) {
            String address = endpointInfo.getAddress();
            try {
                wsdlDescription = new URI(address + "?wsdl");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            endpointInfo.setProperty("URI", (Object)wsdlDescription);
        }
        message.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlDescription);
        return msgInfo;
    }
}

