/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.jbi.interceptor;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.jbi.JBIFault;
import org.apache.cxf.binding.jbi.JBIMessage;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIFaultOutInterceptor
extends AbstractPhaseInterceptor<JBIMessage> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JBIFaultOutInterceptor.class);

    public JBIFaultOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(JBIMessage message) throws Fault {
        message.put(Message.RESPONSE_CODE, new Integer(500));
        NSStack nsStack = new NSStack();
        nsStack.push();
        try {
            XMLStreamWriter writer = this.getWriter(message);
            Fault fault = this.getFault(message);
            JBIFault jbiFault = JBIFault.createFault(fault);
            nsStack.add("http://cxf.apache.org/bindings/jbi");
            String prefix = nsStack.getPrefix("http://cxf.apache.org/bindings/jbi");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"JBIFault", (String)"http://cxf.apache.org/bindings/jbi");
            if (!jbiFault.hasDetails()) {
                writer.writeEmptyElement("fault");
            } else {
                Element detail = jbiFault.getDetail();
                NodeList details = detail.getChildNodes();
                for (int i = 0; i < details.getLength(); ++i) {
                    if (!(details.item(i) instanceof Element)) continue;
                    StaxUtils.writeNode((Node)details.item(i), (XMLStreamWriter)writer, (boolean)true);
                    break;
                }
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    protected Fault getFault(JBIMessage message) {
        Exception e = (Exception)message.getContent(Exception.class);
        if (e == null) {
            throw new IllegalStateException("No exception on this message!");
        }
        Fault fault = e instanceof Fault ? (Fault)e : new Fault((Throwable)e);
        return fault;
    }

    protected XMLStreamWriter getWriter(JBIMessage message) {
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        if (writer == null) {
            throw new IllegalStateException("No XMLStreamWriter on this message");
        }
        return writer;
    }
}

