/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.ws.RequestWrapper;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.Wrapper;
import org.apache.cxf.tools.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResponseWrapper
extends Wrapper {
    @Override
    public void setOperationInfo(OperationInfo op) {
        super.setOperationInfo(op);
        this.setName(((MessagePartInfo)op.getOutput().getMessageParts().get(0)).getElementQName());
        this.setClassName((String)((MessagePartInfo)op.getOutput().getMessageParts().get(0)).getProperty("RESPONSE.WRAPPER.CLASSNAME"));
    }

    @Override
    public boolean isWrapperAbsent(Method method) {
        javax.xml.ws.ResponseWrapper resWrapper = method.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        return this.getClassName() == null && (resWrapper == null || StringUtils.isEmpty((String)resWrapper.className()));
    }

    public String getWrapperTns(Method method) {
        RequestWrapper reqWrapper = method.getAnnotation(RequestWrapper.class);
        if (reqWrapper != null) {
            return reqWrapper.targetNamespace();
        }
        return null;
    }

    @Override
    protected List<JavaField> buildFields() {
        return this.buildFields(this.getMethod(), this.getOperationInfo().getUnwrappedOperation().getOutput());
    }

    protected List<JavaField> buildFields(Method method, MessageInfo message) {
        ArrayList<JavaField> fields = new ArrayList<JavaField>();
        Class<Void> returnType = method.getReturnType();
        JavaField field = new JavaField();
        if (CollectionUtils.isEmpty((Collection)message.getMessageParts())) {
            return fields;
        }
        MessagePartInfo part = (MessagePartInfo)message.getMessageParts().get(0);
        field.setName(part.getName().getLocalPart());
        if (!returnType.isAssignableFrom(Void.TYPE)) {
            String type = returnType.isArray() ? (this.isBuiltInTypes(returnType.getComponentType()) ? returnType.getComponentType().getSimpleName() + "[]" : returnType.getComponentType().getName() + "[]") : returnType.getName();
            field.setType(type);
            field.setTargetNamespace("");
        }
        fields.add(field);
        Class<?>[] paramClasses = method.getParameterTypes();
        for (MessagePartInfo mpi : message.getMessageParts()) {
            int idx = mpi.getIndex();
            if (idx < 0) continue;
            String name = mpi.getName().getLocalPart();
            Class<?> clz = paramClasses[idx];
            String type = clz.isArray() ? (this.isBuiltInTypes(clz.getComponentType()) ? clz.getComponentType().getSimpleName() + "[]" : clz.getComponentType().getName() + "[]") : clz.getName();
            fields.add(new JavaField(name, type, ""));
        }
        return fields;
    }

    @Override
    public WrapperBeanClass getWrapperBeanClass(Method method) {
        javax.xml.ws.ResponseWrapper resWrapper = method.getAnnotation(javax.xml.ws.ResponseWrapper.class);
        String resClassName = this.getClassName();
        String resNs = null;
        if (resWrapper != null) {
            resClassName = resWrapper.className().length() > 0 ? resWrapper.className() : resClassName;
            String string = resNs = resWrapper.targetNamespace().length() > 0 ? resWrapper.targetNamespace() : null;
        }
        if (resClassName == null) {
            resClassName = this.getPackageName(method) + ".jaxws." + AnnotationUtil.capitalize((String)method.getName()) + "Response";
        }
        WrapperBeanClass jClass = new WrapperBeanClass();
        jClass.setFullClassName(resClassName);
        jClass.setNamespace(resNs);
        return jClass;
    }
}

