/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.ByteArrayEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Server;

public class LocalConnector
extends AbstractConnector {
    ByteArrayEndPoint endp;
    ByteArrayBuffer in;
    ByteArrayBuffer out;
    Server server;
    boolean accepting;
    boolean _keepOpen;

    public LocalConnector() {
        this.setPort(1);
    }

    public Object getConnection() {
        return this.endp;
    }

    public void setServer(Server server) {
        super.setServer(server);
        this.server = server;
    }

    public void clear() {
        this.in.clear();
        this.out.clear();
    }

    public void reopen() {
        this.in.clear();
        this.out.clear();
        this.endp = new ByteArrayEndPoint();
        this.endp.setIn(this.in);
        this.endp.setOut(this.out);
        this.accepting = false;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.in = new ByteArrayBuffer(8192);
        this.out = new ByteArrayBuffer(8192);
        this.endp = new ByteArrayEndPoint();
        this.endp.setIn(this.in);
        this.endp.setOut(this.out);
        this.accepting = false;
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponses(String requests, boolean keepOpen) throws Exception {
        this.in.put(new ByteArrayBuffer(requests));
        LocalConnector localConnector = this;
        synchronized (localConnector) {
            this._keepOpen = keepOpen;
            this.accepting = true;
            this.notify();
            while (this.accepting) {
                this.wait();
            }
        }
        return this.out.toString();
    }

    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accept(int acceptorID) throws IOException, InterruptedException {
        HttpConnection connection = null;
        while (this.isRunning()) {
            LocalConnector localConnector = this;
            synchronized (localConnector) {
                try {
                    while (!this.accepting) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            try {
                if (connection == null) {
                    connection = new HttpConnection(this, this.endp, this.getServer());
                    this.connectionOpened(connection);
                }
                while (this.in.length() > 0) {
                    connection.handle();
                }
            }
            finally {
                if (!this._keepOpen) {
                    this.connectionClosed(connection);
                    connection.destroy();
                    connection = null;
                }
                localConnector = this;
                synchronized (localConnector) {
                    this.accepting = false;
                    this.notify();
                }
            }
        }
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }
}

