/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindingFactoryManagerImpl
implements BindingFactoryManager {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(BindingFactoryManagerImpl.class);
    final Map<String, BindingFactory> bindingFactories;
    Bus bus;

    public BindingFactoryManagerImpl() throws BusException {
        this.bindingFactories = new ConcurrentHashMap<String, BindingFactory>();
    }

    public BindingFactoryManagerImpl(Map<String, BindingFactory> bindingFactories) {
        if (!(bindingFactories instanceof ConcurrentHashMap)) {
            bindingFactories = new ConcurrentHashMap<String, BindingFactory>(bindingFactories);
        }
        this.bindingFactories = bindingFactories;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension(this, BindingFactoryManager.class);
        }
    }

    @Override
    public void registerBindingFactory(String name, BindingFactory factory) {
        this.bindingFactories.put(name, factory);
    }

    @Override
    public void unregisterBindingFactory(String name) {
        this.bindingFactories.remove(name);
    }

    @Override
    public BindingFactory getBindingFactory(String namespace) throws BusException {
        BindingFactory factory = this.bindingFactories.get(namespace);
        if (null == factory) {
            throw new BusException(new Message("NO_BINDING_FACTORY_EXC", BUNDLE, namespace));
        }
        return factory;
    }
}

