/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientProxyFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public ClientProxyFactoryBeanDefinitionParser() {
        this.setBeanClass(Object.class);
    }

    protected String getSuffix() {
        return ".simple-client";
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder clientBean) {
        BeanDefinitionBuilder bean = BeanDefinitionBuilder.rootBeanDefinition((Class)this.getProxyFactoryClass());
        NamedNodeMap atts = element.getAttributes();
        boolean createdFromAPI = false;
        boolean setBus = false;
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                clientBean.setAbstract(true);
                createdFromAPI = true;
                continue;
            }
            if (!"id".equals(name) && this.isAttribute(pre, name)) {
                if ("endpointName".equals(name) || "serviceName".equals(name)) {
                    QName q = this.parseQName(element, val);
                    bean.addPropertyValue(name, (Object)q);
                    continue;
                }
                if ("name".equals(name)) continue;
                if ("bus".equals(name)) {
                    setBus = true;
                }
                this.mapToProperty(bean, name, val);
                continue;
            }
            if (!"abstract".equals(name)) continue;
            bean.setAbstract(true);
            clientBean.setAbstract(true);
        }
        if (!setBus && ctx.getRegistry().containsBeanDefinition("cxf")) {
            bean.addPropertyReference("bus", "cxf");
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getLocalName();
            if ("properties".equals(n.getLocalName())) {
                Map map = ctx.getDelegate().parseMapElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                bean.addPropertyValue("properties", (Object)map);
                continue;
            }
            if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name)) {
                List list = ctx.getDelegate().parseListElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                bean.addPropertyValue(n.getLocalName(), (Object)list);
                continue;
            }
            this.setFirstChildAsProperty((Element)n, ctx, bean, n.getLocalName());
        }
        String id = this.getIdOrName(element);
        if (createdFromAPI) {
            id = id + this.getSuffix();
        }
        String factoryId = id + ".proxyFactory";
        ctx.getRegistry().registerBeanDefinition(factoryId, (BeanDefinition)bean.getBeanDefinition());
        clientBean.getBeanDefinition().setAttribute("id", (Object)id);
        clientBean.setFactoryBean(factoryId, "create");
    }

    protected Class getProxyFactoryClass() {
        return ClientProxyFactoryBean.class;
    }
}

