/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final int THRESHHOLD = 102400;
    private static final Logger LOG = Logger.getLogger(AttachmentInInterceptor.class.getName());

    public AttachmentInInterceptor() {
        super("receive");
    }

    @Override
    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            LOG.info("AttachmentInInterceptor skipped in HTTP GET method");
            return;
        }
        String contentType = (String)message.get("Content-Type");
        if (contentType != null && contentType.toLowerCase().indexOf("multipart/related") != -1) {
            AttachmentDeserializer ad = new AttachmentDeserializer(message);
            try {
                ad.initializeAttachments();
            }
            catch (IOException e) {
                throw new Fault(e);
            }
        }
    }

    @Override
    public void handleFault(Message messageParam) {
    }
}

