/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServicePermission;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends javax.xml.ws.Endpoint
implements InterceptorProvider,
Configurable {
    public static final String CHECK_PUBLISH_ENDPOINT_PERMISSON_PROPERTY = "org.apache.cxf.jaxws.checkPublishEndpointPermission";
    private static final WebServicePermission PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Bus bus;
    private Object implementor;
    private Server server;
    private JaxWsServerFactoryBean serverFactory;
    private JaxWsServiceFactoryBean serviceFactory;
    private Service service;
    private Map<String, Object> properties;
    private List<Source> metadata;
    private Executor executor;
    private String bindingUri;
    private String wsdlLocation;
    private String address;
    private QName endpointName;
    private QName serviceName;
    private List<AbstractFeature> features;
    private List<Interceptor> in = new ModCountCopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> out = new ModCountCopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> outFault = new ModCountCopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> inFault = new ModCountCopyOnWriteArrayList<Interceptor>();

    public EndpointImpl(Object implementor) {
        this(BusFactory.getThreadDefaultBus(), implementor);
    }

    public EndpointImpl(Bus b, Object implementor, JaxWsServerFactoryBean sf) {
        this.bus = b;
        this.serverFactory = sf;
        this.implementor = implementor;
    }

    public EndpointImpl(Bus b, Object i, String bindingUri, String wsdl) {
        this.bus = b;
        this.implementor = i;
        this.bindingUri = bindingUri;
        this.wsdlLocation = wsdl == null ? null : new String(wsdl);
        this.serverFactory = new JaxWsServerFactoryBean();
    }

    public EndpointImpl(Bus b, Object i, String bindingUri) {
        this(b, i, bindingUri, null);
    }

    public EndpointImpl(Bus bus, Object implementor) {
        this(bus, implementor, (String)null);
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Service getService() {
        return this.service;
    }

    public JaxWsServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public Class getImplementorClass() {
        return this.implementor.getClass();
    }

    public List<Source> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(Object arg0) {
        this.checkPublishPermission();
    }

    public void publish(String addr) {
        this.doPublish(addr);
    }

    public void setServiceFactory(JaxWsServiceFactoryBean sf) {
        this.serviceFactory = sf;
    }

    public void setMetadata(List<Source> metadata) {
        this.metadata = metadata;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
        if (this.server != null) {
            this.server.getEndpoint().putAll(properties);
        }
    }

    public void stop() {
        if (null != this.server) {
            this.server.stop();
        }
    }

    @Override
    public String getBeanName() {
        return this.endpointName.toString() + ".jaxws-endpoint";
    }

    protected void checkProperties() {
        if (this.properties != null) {
            if (this.properties.containsKey("javax.xml.ws.wsdl.description")) {
                this.wsdlLocation = this.properties.get("javax.xml.ws.wsdl.description").toString();
            }
            if (this.properties.containsKey("javax.xml.ws.wsdl.port")) {
                this.endpointName = (QName)this.properties.get("javax.xml.ws.wsdl.port");
            }
            if (this.properties.containsKey("javax.xml.ws.wsdl.service")) {
                this.serviceName = (QName)this.properties.get("javax.xml.ws.wsdl.service");
            }
        }
    }

    protected void doPublish(String addr) {
        this.checkPublishPermission();
        ServerImpl serv = this.getServer(addr);
        if (addr != null) {
            serv.getEndpoint().getEndpointInfo().setAddress(addr);
        }
        serv.start();
    }

    public ServerImpl getServer() {
        return this.getServer(null);
    }

    public synchronized ServerImpl getServer(String addr) {
        if (this.server == null) {
            this.checkProperties();
            if (this.endpointName == null) {
                JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
                this.endpointName = implInfo.getEndpointName();
            }
            if (this.serviceFactory != null) {
                this.serverFactory.setServiceFactory(this.serviceFactory);
            }
            this.configureObject(this);
            this.serverFactory.setAddress(addr);
            this.serverFactory.setStart(false);
            this.serverFactory.setEndpointName(this.endpointName);
            this.serverFactory.setServiceBean(this.implementor);
            this.serverFactory.setBus(this.bus);
            this.serverFactory.setFeatures(this.features);
            if (this.getWsdlLocation() != null) {
                this.serverFactory.setWsdlURL(this.getWsdlLocation());
            }
            if (this.bindingUri != null) {
                this.serverFactory.setBindingId(this.bindingUri);
            }
            if (this.serviceName != null) {
                this.serverFactory.getServiceFactory().setServiceName(this.serviceName);
            }
            this.configureObject(this.serverFactory);
            this.server = this.serverFactory.create();
            Endpoint endpoint = this.getEndpoint();
            if (this.getInInterceptors() != null) {
                endpoint.getInInterceptors().addAll(this.getInInterceptors());
            }
            if (this.getOutInterceptors() != null) {
                endpoint.getOutInterceptors().addAll(this.getOutInterceptors());
            }
            if (this.getInFaultInterceptors() != null) {
                endpoint.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
            }
            if (this.getOutFaultInterceptors() != null) {
                endpoint.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
            }
            if (this.properties != null) {
                endpoint.putAll(this.properties);
            }
            this.configureObject(endpoint.getService());
            this.configureObject(endpoint);
            if (this.getWsdlLocation() == null) {
                this.setWsdlLocation(this.serverFactory.getWsdlURL());
            }
        }
        return (ServerImpl)this.server;
    }

    Endpoint getEndpoint() {
        return this.getServer(null).getEndpoint();
    }

    private void configureObject(Object instance) {
        Configurer configurer = this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    protected void checkPublishPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)PUBLISH_PERMISSION);
        } else if (Boolean.getBoolean(CHECK_PUBLISH_ENDPOINT_PERMISSON_PROPERTY)) {
            AccessController.checkPermission((Permission)PUBLISH_PERMISSION);
        }
    }

    public void publish() {
        this.publish(this.getAddress());
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(QName endpointName) {
        this.endpointName = endpointName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setBindingUri(String binding) {
        this.bindingUri = binding;
    }

    public String getBindingUri() {
        return this.bindingUri;
    }

    @Override
    public List<Interceptor> getOutFaultInterceptors() {
        return this.outFault;
    }

    @Override
    public List<Interceptor> getInFaultInterceptors() {
        return this.inFault;
    }

    @Override
    public List<Interceptor> getInInterceptors() {
        return this.in;
    }

    @Override
    public List<Interceptor> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor> interceptors) {
        this.in = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutInterceptors(List<Interceptor> interceptors) {
        this.out = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor> interceptors) {
        this.outFault = interceptors;
    }

    public List<AbstractFeature> getFeatures() {
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }
}

