/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Service;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.Service;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

public class DispatchOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchOutInterceptor.class);
    private DispatchOutEndingInterceptor ending = new DispatchOutEndingInterceptor();

    public DispatchOutInterceptor() {
        super("write");
    }

    public void handleMessage(Message message) throws Fault {
        Service.Mode m = message.getExchange().get(Service.Mode.class);
        OutputStream os = message.getContent(OutputStream.class);
        Object obj = message.getContent(Object.class);
        Service service = message.getExchange().get(Service.class);
        if (obj == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("DISPATCH_OBJECT_CANNOT_BE_NULL", LOG, new Object[0]));
        }
        try {
            if (message instanceof SoapMessage) {
                if (m == Service.Mode.MESSAGE) {
                    if (obj instanceof DataSource) {
                        throw new RuntimeException(obj.getClass() + " is not valid in Message mode for SOAP/HTTP");
                    }
                } else if (m == Service.Mode.PAYLOAD) {
                    if (obj instanceof SOAPMessage || obj instanceof DataSource) {
                        throw new RuntimeException(obj.getClass() + " is not valid in PAYLOAD mode with SOAP/HTTP");
                    }
                    SOAPMessage msg = this.initSOAPMessage();
                    DataWriter<Node> dataWriter = this.getDataWriter(message, service, Node.class);
                    dataWriter.write(obj, (Node)msg.getSOAPBody());
                    message.setContent(Object.class, msg);
                    message.setContent(SOAPMessage.class, msg);
                    msg.writeTo((OutputStream)System.out);
                }
            } else if (message instanceof XMLMessage) {
                if (m == Service.Mode.MESSAGE && obj instanceof SOAPMessage) {
                    throw new RuntimeException("SOAPMessage is not valid in MESSAGE mode with XML/HTTP");
                }
                if (m == Service.Mode.PAYLOAD && (obj instanceof SOAPMessage || obj instanceof DataSource)) {
                    throw new RuntimeException(obj.getClass() + " is not valid in PAYLOAD mode with XML/HTTP");
                }
                DataWriter<XMLStreamWriter> dataWriter = this.getDataWriter(message, service, XMLStreamWriter.class);
                XMLStreamWriter xmlWriter = message.getContent(XMLStreamWriter.class);
                if (xmlWriter == null) {
                    xmlWriter = StaxUtils.createXMLStreamWriter(os, "UTF-8");
                }
                dataWriter.write(obj, xmlWriter);
                message.setContent(XMLStreamWriter.class, xmlWriter);
            }
        }
        catch (Exception ex) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("EXCEPTION_WRITING_OBJECT", LOG, new Object[0]));
        }
        message.getInterceptorChain().add(this.ending);
    }

    private SOAPMessage initSOAPMessage() throws SOAPException {
        SOAPMessage msg = MessageFactory.newInstance().createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        msg.getSOAPPart().getEnvelope().addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return msg;
    }

    private void doTransform(Object obj, OutputStream os) throws TransformerException, IOException {
        if (obj instanceof Source) {
            Transformer transformer = XMLUtils.newTransformer();
            transformer.transform((Source)obj, new StreamResult(os));
        }
        if (obj instanceof DataSource) {
            InputStream is = ((DataSource)obj).getInputStream();
            IOUtils.copy(((DataSource)obj).getInputStream(), os);
            is.close();
        }
    }

    private class DispatchOutEndingInterceptor
    extends AbstractOutDatabindingInterceptor {
        public DispatchOutEndingInterceptor() {
            super("write-ending");
        }

        public void handleMessage(Message message) throws Fault {
            OutputStream os = message.getContent(OutputStream.class);
            Object obj = message.getContent(Object.class);
            XMLStreamWriter xmlWriter = message.getContent(XMLStreamWriter.class);
            try {
                if (xmlWriter != null) {
                    xmlWriter.flush();
                } else if (obj instanceof SOAPMessage) {
                    ((SOAPMessage)obj).writeTo(os);
                } else if (obj instanceof Source || obj instanceof DataSource) {
                    DispatchOutInterceptor.this.doTransform(obj, os);
                }
                os.flush();
            }
            catch (Exception ex) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("EXCEPTION_WRITING_OBJECT", LOG, new Object[0]));
            }
        }
    }
}

