/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class CXFServlet
extends HttpServlet {
    static final Map<String, WeakReference<Bus>> BUS_MAP = new Hashtable<String, WeakReference<Bus>>();
    static final Logger LOG = Logger.getLogger(CXFServlet.class.getName());
    private Bus bus;
    private ServletTransportFactory servletTransportFactory;
    private ServletController controller;
    private GenericApplicationContext childCtx;

    public ServletController createServletController() {
        return new ServletController(this.servletTransportFactory, this);
    }

    public ServletController getController() {
        return this.controller;
    }

    public Bus getBus() {
        return this.bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            WeakReference<Bus> ref;
            BusFactory.setThreadDefaultBus(null);
            String busid = servletConfig.getInitParameter("bus.id");
            if (null != busid && null != (ref = BUS_MAP.get(busid))) {
                this.bus = (Bus)ref.get();
                BusFactory.setThreadDefaultBus(this.bus);
            }
            String springCls = "org.springframework.context.ApplicationContext";
            try {
                ClassLoaderUtils.loadClass(springCls, ((Object)((Object)this)).getClass());
                this.loadSpringBus(servletConfig);
            }
            catch (ClassNotFoundException e) {
                this.loadBusNoConfig(servletConfig);
            }
            if (null != busid) {
                BUS_MAP.put(busid, new WeakReference<Bus>(this.bus));
            }
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    private void loadBusNoConfig(ServletConfig servletConfig) throws ServletException {
        if (this.bus == null) {
            this.bus = BusFactory.newInstance().createBus();
        }
        ResourceManager resourceManager = this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver(new ServletContextResourceResolver(servletConfig.getServletContext()));
        this.controller = this.createServletController();
        this.replaceDestionFactory();
    }

    private void loadSpringBus(ServletConfig servletConfig) throws ServletException {
        ServletContext svCtx = this.getServletContext();
        ApplicationContext ctx = (ApplicationContext)svCtx.getAttribute("interface org.springframework.web.context.WebApplicationContext.ROOT");
        if (ctx == null) {
            ctx = (ApplicationContext)svCtx.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
        }
        this.bus = ctx == null ? new SpringBusFactory().createBus("/META-INF/cxf/cxf-servlet.xml") : new SpringBusFactory(ctx).createBus();
        ResourceManager resourceManager = this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver(new ServletContextResourceResolver(servletConfig.getServletContext()));
        this.replaceDestionFactory();
        this.controller = this.createServletController();
        this.loadAdditionalConfig(ctx, servletConfig);
    }

    protected void loadAdditionalConfig(ApplicationContext ctx, ServletConfig servletConfig) throws ServletException {
        String location = servletConfig.getInitParameter("config-location");
        if (location == null) {
            location = "/WEB-INF/cxf-servlet.xml";
        }
        InputStream is = null;
        try {
            URIResolver resolver;
            is = servletConfig.getServletContext().getResourceAsStream(location);
            if ((is == null || is.available() == -1) && (resolver = new URIResolver(location)).isResolved()) {
                is = resolver.getInputStream();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (is != null) {
            this.childCtx = new GenericApplicationContext(ctx);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.childCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(is, location));
            this.childCtx.refresh();
        }
    }

    protected DestinationFactory createServletTransportFactory() {
        if (this.servletTransportFactory == null) {
            this.servletTransportFactory = new ServletTransportFactory(this.bus);
        }
        return this.servletTransportFactory;
    }

    private void registerTransport(DestinationFactory factory, String namespace) {
        this.bus.getExtension(DestinationFactoryManager.class).registerDestinationFactory(namespace, factory);
    }

    private void replaceDestionFactory() throws ServletException {
        DestinationFactoryManager dfm = this.bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof ServletTransportFactory) {
                this.servletTransportFactory = (ServletTransportFactory)df;
                return;
            }
        }
        catch (BusException e) {
            // empty catch block
        }
        DestinationFactory factory = this.createServletTransportFactory();
        this.registerTransport(factory, "http://schemas.xmlsoap.org/wsdl/soap/http");
        this.registerTransport(factory, "http://schemas.xmlsoap.org/soap/http");
        this.registerTransport(factory, "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        this.registerTransport(factory, "http://schemas.xmlsoap.org/wsdl/http/");
        this.registerTransport(factory, "http://cxf.apache.org/transports/http/configuration");
        this.registerTransport(factory, "http://cxf.apache.org/bindings/xformat");
    }

    public void destroy() {
        if (this.childCtx != null) {
            this.childCtx.destroy();
        }
        String s = this.bus.getId();
        BUS_MAP.remove(s);
        this.bus.shutdown(true);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.invoke(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.invoke(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.invoke(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            BusFactory.setThreadDefaultBus(this.getBus());
            this.controller.invoke(request, response);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }
}

