/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.VelocityGenerator;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.version.Version;

public abstract class AbstractGenerator
implements FrontEndGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractGenerator.class);
    protected ToolContext env;
    protected String name;
    protected final VelocityGenerator velocity = new VelocityGenerator();

    protected void doWrite(String templateName, Writer outputs) throws ToolException {
        this.velocity.doWrite(templateName, outputs);
    }

    protected boolean isCollision(String packageName, String filename) throws ToolException {
        return this.isCollision(packageName, filename, ".java");
    }

    protected boolean isCollision(String packageName, String filename, String ext) throws ToolException {
        if (this.env.optionSet("overwrite")) {
            return false;
        }
        FileWriterUtil fw = new FileWriterUtil((String)this.env.get("outputdir"));
        return fw.isCollision(packageName, filename + ext);
    }

    protected Writer parseOutputName(String packageName, String filename, String ext) throws ToolException {
        FileWriterUtil fw = null;
        Writer writer = null;
        fw = new FileWriterUtil((String)this.env.get("outputdir"));
        try {
            writer = fw.getWriter(packageName, filename + ext);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{packageName + "." + filename + ext});
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }

    protected Writer parseOutputName(String packageName, String filename) throws ToolException {
        ClassCollector collector = (ClassCollector)this.env.get(ClassCollector.class);
        if ("sei.generator".equals(this.name)) {
            collector.addSeiClassName(packageName, filename, packageName + "." + filename);
        }
        if ("clt.generator".equals(this.name)) {
            collector.addClientClassName(packageName, filename, packageName + "." + filename);
        }
        if ("fault.generator".equals(this.name)) {
            collector.addExceptionClassName(packageName, filename, packageName + "." + filename);
        }
        if ("service.generator".equals(this.name)) {
            collector.addServiceClassName(packageName, filename, packageName + "." + filename);
        }
        if ("svr.generator".equals(this.name)) {
            collector.addServiceClassName(packageName, filename, packageName + "." + filename);
        }
        return this.parseOutputName(packageName, filename, ".java");
    }

    protected void setAttributes(String n, Object value) {
        this.velocity.setAttributes(n, value);
    }

    protected void setCommonAttributes() {
        this.setAttributes("currentdate", Calendar.getInstance().getTime());
        this.setAttributes("version", Version.getCurrentVersion());
    }

    protected void clearAttributes() {
        this.velocity.clearAttributes();
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public String getName() {
        return this.name;
    }
}

