/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.customiztion;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.StAXUtil;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customiztion.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizationParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CustomizationParser.class);
    private static final XPathFactory XPF = XPathFactory.newInstance();
    private final XPath xpath = XPF.newXPath();
    private ToolContext env;
    private final List<Element> jaxwsBindings = new ArrayList<Element>();
    private final List<InputSource> jaxbBindings = new ArrayList<InputSource>();
    private Element handlerChains;
    private Element wsdlNode;
    private String wsdlURL;

    public CustomizationParser() {
        this.jaxwsBindings.clear();
        this.jaxbBindings.clear();
    }

    public Element getHandlerChains() {
        return this.handlerChains;
    }

    public void parse(ToolContext pe) {
        String[] bindingFiles;
        this.env = pe;
        try {
            this.wsdlURL = URIParserUtil.getAbsoluteURI((String)((String)this.env.get("wsdlurl")));
            this.wsdlNode = this.getTargetNode(this.wsdlURL);
            bindingFiles = (String[])this.env.get("binding");
            if (bindingFiles == null) {
                return;
            }
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)this.env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            try {
                this.addBinding(bindingFiles[i]);
                continue;
            }
            catch (XMLStreamException xse) {
                Message msg = new Message("STAX_PASER_ERROR", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)xse);
            }
        }
        for (Element element : this.jaxwsBindings) {
            this.internalizeBinding(element, "");
        }
        this.buildHandlerChains();
    }

    public Element getTargetNode(String wsdlLoc) {
        Document doc = null;
        InputStream ins = null;
        try {
            URIResolver resolver = new URIResolver(wsdlLoc);
            ins = resolver.getInputStream();
        }
        catch (IOException e1) {
            throw new ToolException((Throwable)e1);
        }
        try {
            doc = DOMUtils.readXml((InputStream)ins);
        }
        catch (Exception e) {
            Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, new Object[]{wsdlLoc});
            throw new ToolException(msg, (Throwable)e);
        }
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    private void buildHandlerChains() {
        for (Element jaxwsBinding : this.jaxwsBindings) {
            NodeList nl = jaxwsBinding.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            if (nl.getLength() == 0) continue;
            this.handlerChains = (Element)nl.item(0);
            return;
        }
    }

    private void internalizeBinding(Element bindings, String expression) {
        if (bindings.getAttributeNode("wsdlLocation") != null) {
            expression = "/";
        }
        if (this.isGlobaleBindings(bindings)) {
            String pfx = this.wsdlNode.getPrefix();
            pfx = pfx == null ? "" : pfx + ":";
            ContextImpl ctx = new ContextImpl(this.wsdlNode);
            Node node = this.queryXPathNode(this.wsdlNode, ctx, "//" + pfx + "definitions");
            this.copyBindingsToWsdl(node, bindings, ctx);
        }
        if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") != null) {
            expression = expression + "/" + bindings.getAttribute("node");
            Node node = null;
            NodeList nestedJaxbNodes = this.getNestedJaxbBinding(bindings);
            NodeList nestedJaxbSchemaBindingNodes = this.getNestedJaxbSchemaBinding(bindings);
            ContextImpl ctx = new ContextImpl(bindings);
            node = this.queryXPathNode(this.wsdlNode, ctx, expression);
            if (node != null && nestedJaxbNodes.getLength() == 0 && nestedJaxbSchemaBindingNodes.getLength() == 0) {
                this.copyBindingsToWsdl(node, bindings, ctx);
            }
            if (node != null && nestedJaxbNodes.getLength() != 0) {
                Node jaxbNode = nestedJaxbNodes.item(0);
                String xpathExpress = DOMUtils.getAttribute((Node)jaxbNode, (String)"node");
                Node schemaNode = this.getSchemaNode(node);
                ctx = new ContextImpl(bindings);
                Node targetNode = this.queryXPathNode(schemaNode, ctx, xpathExpress);
                Element schemaElement = (Element)schemaNode;
                String jaxbPrefix = schemaElement.lookupPrefix("http://java.sun.com/xml/ns/jaxb");
                if (jaxbPrefix == null) {
                    schemaElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
                    schemaElement.setAttribute("jaxb:version", "2.0");
                }
                Element annoElement = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
                Element appinfoEle = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                annoElement.appendChild(appinfoEle);
                for (int j = 0; j < jaxbNode.getChildNodes().getLength(); ++j) {
                    Node cloneNode = ProcessorUtil.cloneNode(node.getOwnerDocument(), jaxbNode.getChildNodes().item(j), true);
                    appinfoEle.appendChild(cloneNode);
                }
                if (targetNode.getChildNodes().getLength() > 0) {
                    targetNode.insertBefore(annoElement, targetNode.getChildNodes().item(0));
                } else {
                    targetNode.appendChild(annoElement);
                }
            } else if (node != null && nestedJaxbSchemaBindingNodes.getLength() != 0) {
                Element schemaElement = (Element)node;
                Node jaxbNode = nestedJaxbSchemaBindingNodes.item(0);
                String jaxbPrefix = schemaElement.lookupPrefix("http://java.sun.com/xml/ns/jaxb");
                if (jaxbPrefix == null) {
                    schemaElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
                    schemaElement.setAttribute("jaxb:version", "2.0");
                }
                Element annoElement = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
                Element appinfoEle = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                annoElement.appendChild(appinfoEle);
                Node cloneNode = ProcessorUtil.cloneNode(node.getOwnerDocument(), jaxbNode, true);
                appinfoEle.appendChild(cloneNode);
                if (schemaElement.getChildNodes().getLength() > 0) {
                    schemaElement.insertBefore(annoElement, schemaElement.getChildNodes().item(0));
                } else {
                    schemaElement.appendChild(annoElement);
                }
            }
        }
        Element[] children = this.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxws");
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getNodeType() != 1) continue;
            this.internalizeBinding(children[i], expression);
        }
    }

    private void copyBindingsToWsdl(Node node, Node bindings, ContextImpl ctx) {
        if (bindings.getNamespaceURI().equals(ToolConstants.JAXWS_BINDINGS.getNamespaceURI())) {
            bindings.setPrefix("jaxws");
        }
        for (Map.Entry<String, String> ent : ctx.getUsedNamespaces().entrySet()) {
            if (node.lookupNamespaceURI(ent.getKey()) != null) continue;
            node.getOwnerDocument().getDocumentElement().setAttribute("xmlns:" + ent.getKey(), ent.getValue());
        }
        for (int i = 0; i < bindings.getChildNodes().getLength(); ++i) {
            Node childNode = bindings.getChildNodes().item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNamespaceURI().equals(ToolConstants.JAXWS_BINDINGS.getNamespaceURI())) continue;
            childNode.setPrefix("jaxws");
        }
        Node cloneNode = ProcessorUtil.cloneNode(node.getOwnerDocument(), bindings, true);
        Node firstChild = DOMUtils.getChild((Node)node, (String)"jaxws:bindings");
        if (firstChild == null && cloneNode.getNodeName().indexOf("bindings") == -1) {
            this.wsdlNode.setAttribute("xmlns:jaxws", ToolConstants.JAXWS_BINDINGS.getNamespaceURI());
            Element jaxwsBindingElement = node.getOwnerDocument().createElement("jaxws:bindings");
            node.appendChild(jaxwsBindingElement);
            firstChild = jaxwsBindingElement;
        }
        if (firstChild == null && cloneNode.getNodeName().indexOf("bindings") > -1) {
            firstChild = node;
            if (this.wsdlNode.getAttributeNode("xmls:jaxws") == null) {
                this.wsdlNode.setAttribute("xmlns:jaxws", ToolConstants.JAXWS_BINDINGS.getNamespaceURI());
            }
        }
        Element cloneEle = (Element)cloneNode;
        cloneEle.removeAttribute("node");
        for (int i = 0; i < cloneNode.getChildNodes().getLength(); ++i) {
            Element childElement;
            Attr attrNode;
            Node child = cloneNode.getChildNodes().item(i);
            if (child.getNodeType() != 1 || (attrNode = (childElement = (Element)child).getAttributeNode("node")) == null) continue;
            cloneNode.removeChild(child);
        }
        firstChild.appendChild(cloneNode);
    }

    private Node getSchemaNode(Node node) {
        if (!"schema".equals(node.getLocalName())) {
            while (node.getParentNode() != null) {
                if (!"schema".equals((node = node.getParentNode()).getLocalName())) continue;
                return node;
            }
            return null;
        }
        return node;
    }

    private boolean isGlobaleBindings(Element binding) {
        Element ele;
        boolean globleNode = binding.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && binding.getLocalName().equals("package") || binding.getLocalName().equals("enableAsyncMapping") || binding.getLocalName().equals("enableAdditionalSOAPHeaderMapping") || binding.getLocalName().equals("enableWrapperStyle") || binding.getLocalName().equals("enableMIMEContent");
        Node parentNode = binding.getParentNode();
        return parentNode instanceof Element && (ele = (Element)parentNode).getAttributeNode("wsdlLocation") != null && globleNode;
    }

    private Element[] getChildElements(Element parent, String nsUri) {
        ArrayList<Element> a = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (!(item instanceof Element) || !nsUri.equals(item.getNamespaceURI())) continue;
            a.add((Element)item);
        }
        return a.toArray(new Element[a.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addBinding(String bindingFile) throws XMLStreamException {
        InputSource is = new InputSource(bindingFile);
        XMLStreamReader reader = StAXUtil.createFreshXMLStreamReader((InputSource)is);
        StAXUtil.toStartTag((XMLStreamReader)reader);
        if (this.isValidJaxwsBindingFile(bindingFile, reader)) {
            Element root = null;
            try {
                URIResolver resolver = new URIResolver(bindingFile);
                root = DOMUtils.readXml((InputStream)resolver.getInputStream()).getDocumentElement();
            }
            catch (Exception e1) {
                Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, new Object[]{bindingFile});
                throw new ToolException(msg, (Throwable)e1);
            }
            String wsdlLocation = root.getAttribute("wsdlLocation");
            URI wsdlURI = null;
            try {
                wsdlURI = new URI(wsdlLocation);
            }
            catch (URISyntaxException e) {
                Message msg = new Message("JAXWSBINDINGS_WSDLLOC_ERROR", LOG, new Object[]{wsdlLocation});
                throw new ToolException(msg);
            }
            if (!wsdlURI.isAbsolute()) {
                try {
                    URI baseURI = new URI(bindingFile);
                    wsdlURI = baseURI.resolve(wsdlURI);
                }
                catch (URISyntaxException e) {
                    Message msg = new Message("NOT_URI", LOG, new Object[]{bindingFile});
                    throw new ToolException(msg, (Throwable)e);
                }
            }
            URI normalizedURL = null;
            if (this.wsdlURL != null) {
                normalizedURL = URI.create(this.wsdlURL).normalize();
            }
            if (wsdlURI.normalize().equals(normalizedURL)) {
                this.jaxwsBindings.add(root);
                return;
            }
            String wsdl = (String)this.env.get("wsdlurl");
            Message msg = new Message("NOT_POINTTO_URL", LOG, new Object[]{bindingFile, wsdl});
            throw new ToolException(msg);
        }
        if (this.isValidJaxbBindingFile(reader)) {
            this.jaxbBindings.add(is);
            return;
        }
        Message msg = new Message("UNKNOWN_BINDING_FILE", LOG, new Object[]{bindingFile});
        throw new ToolException(msg);
    }

    private boolean isValidJaxbBindingFile(XMLStreamReader reader) {
        return ToolConstants.JAXB_BINDINGS.equals(reader.getName());
    }

    private boolean isValidJaxwsBindingFile(String bindingLocation, XMLStreamReader reader) {
        String wsdlLocation;
        return ToolConstants.JAXWS_BINDINGS.equals(reader.getName()) && !StringUtils.isEmpty((String)(wsdlLocation = reader.getAttributeValue(null, "wsdlLocation")));
    }

    private Node queryXPathNode(Node target, ContextImpl nsCtx, String expression) {
        NodeList nlst;
        try {
            this.xpath.setNamespaceContext(nsCtx);
            nlst = (NodeList)this.xpath.evaluate(expression, target, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Message msg = new Message("XPATH_ERROR", LOG, new Object[]{expression});
            throw new ToolException(msg, (Throwable)e);
        }
        if (nlst.getLength() != 1) {
            Message msg = new Message("ERROR_TARGETNODE_WITH_XPATH", LOG, new Object[]{expression});
            throw new ToolException(msg);
        }
        Node rnode = nlst.item(0);
        if (!(rnode instanceof Element)) {
            Message msg = new Message("ERROR_TARGETNODE_WITH_XPATH", LOG, new Object[]{expression});
            throw new ToolException(msg);
        }
        return (Element)rnode;
    }

    public Node getWSDLNode() {
        return this.wsdlNode;
    }

    private boolean isJAXWSBindings(Node bindings) {
        return "http://java.sun.com/xml/ns/jaxws".equals(bindings.getNamespaceURI()) && "bindings".equals(bindings.getLocalName());
    }

    private NodeList getNestedJaxbBinding(Element bindings) {
        return bindings.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "bindings");
    }

    private NodeList getNestedJaxbSchemaBinding(Element bindings) {
        return bindings.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "schemaBindings");
    }

    public Element getCustomizedWSDLElement() {
        return this.wsdlNode;
    }

    public List<InputSource> getJaxbBindings() {
        return this.jaxbBindings;
    }

    public static JAXWSBinding mergeJawsBinding(JAXWSBinding binding1, JAXWSBinding binding2) {
        if (binding1 != null && binding2 != null) {
            if (binding2.isEnableAsyncMapping()) {
                binding1.setEnableAsyncMapping(true);
            }
            if (binding2.isEnableWrapperStyle()) {
                binding1.setEnableWrapperStyle(true);
            }
            if (binding2.isEnableMime()) {
                binding1.setEnableMime(true);
            }
            if (binding2.getJaxwsClass() != null) {
                binding1.setJaxwsClass(binding2.getJaxwsClass());
            }
            if (binding2.getJaxwsPara() != null) {
                binding1.setJaxwsPara(binding2.getJaxwsPara());
            }
            return binding1;
        }
        return binding1 == null ? binding2 : binding1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ContextImpl
    implements NamespaceContext {
        private Node targetNode;
        private Map<String, String> pfxMap = new HashMap<String, String>();

        public ContextImpl(Node node) {
            this.targetNode = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String s = this.targetNode.lookupNamespaceURI(prefix);
            if (prefix != null) {
                this.pfxMap.put(prefix, s);
            }
            return s;
        }

        @Override
        public String getPrefix(String nsURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> getUsedNamespaces() {
            return this.pfxMap;
        }
    }
}

