/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.ServletDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTransportFactory
extends AbstractTransportFactory
implements DestinationFactory {
    private Bus bus;
    private Map<String, ServletDestination> destinations = new ConcurrentHashMap<String, ServletDestination>();

    public ServletTransportFactory(Bus b) {
        this.bus = b;
    }

    public ServletTransportFactory() {
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void removeDestination(String path) {
        this.destinations.remove(path);
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        ServletDestination d = this.getDestinationForPath(endpointInfo.getAddress());
        if (d == null) {
            String path = ServletTransportFactory.getTrimmedPath(endpointInfo.getAddress());
            d = new ServletDestination(this.bus, null, endpointInfo, this, path);
            this.destinations.put(path, d);
        }
        return d;
    }

    public ServletDestination getDestinationForPath(String path) {
        return this.destinations.get(ServletTransportFactory.getTrimmedPath(path));
    }

    static String getTrimmedPath(String path) {
        if (path == null) {
            return "/";
        }
        String lh = "http://localhost/";
        String lhs = "https://localhost/";
        if (path.startsWith("http://localhost/")) {
            path = path.substring("http://localhost/".length());
        } else if (path.startsWith("https://localhost/")) {
            path = path.substring("https://localhost/".length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public Collection<ServletDestination> getDestinations() {
        return Collections.unmodifiableCollection(this.destinations.values());
    }

    public Set<String> getDestinationsPaths() {
        return Collections.unmodifiableSet(this.destinations.keySet());
    }
}

