/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.binding.xml.interceptor.XMLFaultInInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLFaultOutInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageOutInterceptor;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class XMLBindingFactory
extends AbstractBindingFactory {
    public Binding createBinding(BindingInfo binding) {
        XMLBinding xb = new XMLBinding(binding);
        xb.getInInterceptors().add(new AttachmentInInterceptor());
        xb.getInInterceptors().add(new StaxInInterceptor());
        xb.getInFaultInterceptors().add(new XMLFaultInInterceptor());
        xb.getOutInterceptors().add(new StaxOutInterceptor());
        if (!Boolean.TRUE.equals(binding.getProperty("databinding.disabled"))) {
            xb.getInInterceptors().add(new URIMappingInterceptor());
            xb.getOutInterceptors().add(new XMLMessageOutInterceptor());
            xb.getInInterceptors().add(new DocLiteralInInterceptor());
            xb.getInInterceptors().add(new XMLMessageInInterceptor());
        }
        xb.getOutFaultInterceptors().add(new StaxOutInterceptor());
        xb.getOutFaultInterceptors().add(new XMLFaultOutInterceptor());
        return xb;
    }

    public BindingInfo createBindingInfo(ServiceInfo service, String namespace, Object config) {
        BindingInfo info = new BindingInfo(service, "http://cxf.apache.org/bindings/xformat");
        info.setName(new QName(service.getName().getNamespaceURI(), service.getName().getLocalPart() + "XMLBinding"));
        for (OperationInfo op : service.getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(op.getName(), op.getInputName(), op.getOutputName());
            info.addOperation(bop);
        }
        return info;
    }
}

