/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyFeature
extends AbstractFeature {
    private Collection<Policy> policies;
    private Collection<Element> policyElements;

    public WSPolicyFeature() {
    }

    public WSPolicyFeature(Policy ... ps) {
        this.policies = new ArrayList<Policy>();
        Collections.addAll(this.policies, ps);
    }

    public void initialize(Client client, Bus bus) {
        Endpoint endpoint = client.getEndpoint();
        this.intializeEndpoint(endpoint, bus);
    }

    public void initialize(Server server, Bus bus) {
        Endpoint endpoint = server.getEndpoint();
        this.intializeEndpoint(endpoint, bus);
    }

    private void intializeEndpoint(Endpoint endpoint, Bus bus) {
        ArrayList<Policy> loadedPolicies = null;
        if (this.policyElements != null) {
            loadedPolicies = new ArrayList<Policy>();
            PolicyBuilder builder = (PolicyBuilder)bus.getExtension(PolicyBuilder.class);
            for (Element e : this.policyElements) {
                loadedPolicies.add(builder.getPolicy(e));
            }
        }
        this.ensurePolicyEngineActivated(bus);
        List sis = endpoint.getService().getServiceInfos();
        for (ServiceInfo si : sis) {
            if (this.policies != null) {
                for (Policy p : this.policies) {
                    si.addExtensor((Object)p);
                }
            }
            if (loadedPolicies == null) continue;
            for (Policy p : loadedPolicies) {
                si.addExtensor((Object)p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePolicyEngineActivated(Bus bus) {
        PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        if (pe == null) {
            PolicyEngineImpl pei = new PolicyEngineImpl();
            pei.setBus(bus);
            bus.setExtension((Object)pei, PolicyEngine.class);
            pe = pei;
        }
        PolicyEngine policyEngine = pe;
        synchronized (policyEngine) {
            if (!pe.isEnabled()) {
                pe.setEnabled(true);
            }
        }
    }

    public Collection<Policy> getPolicies() {
        if (this.policies == null) {
            this.policies = new ArrayList<Policy>();
        }
        return this.policies;
    }

    public void setPolicies(Collection<Policy> policies) {
        this.policies = policies;
    }

    public Collection<Element> getPolicyElements() {
        if (this.policyElements == null) {
            this.policyElements = new ArrayList<Element>();
        }
        return this.policyElements;
    }

    public void setPolicyElements(Collection<Element> policyElements) {
        this.policyElements = policyElements;
    }
}

