/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JAXBContextInitializer
extends ServiceModelVisitor {
    private Set<Class<?>> classes;

    public JAXBContextInitializer(ServiceInfo serviceInfo, Set<Class<?>> classes) {
        super(serviceInfo);
        this.classes = classes;
    }

    @Override
    public void begin(MessagePartInfo part) {
        Class<?> genericType;
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
        if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
        }
        if ((genericType = (Class<?>)part.getProperty("generic.type")) != null) {
            ParameterizedType pt;
            Class cl2;
            if (isFromWrapper && genericType instanceof Class && ((Class)genericType).isArray() && (cl2 = (Class)genericType).isArray() && !Byte.TYPE.equals(cl2.getComponentType())) {
                genericType = cl2.getComponentType();
            }
            this.addType(genericType);
            if (Collection.class.isAssignableFrom(clazz) && genericType instanceof ParameterizedType && (pt = (ParameterizedType)((Object)genericType)).getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                Class<?> arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                clazz = arrayCls;
                part.setTypeClass(clazz);
            }
        }
        this.addClass(clazz);
    }

    private void addType(Type cls) {
        if (cls instanceof Class) {
            this.addClass((Class)cls);
        } else if (cls instanceof ParameterizedType) {
            for (Type t2 : ((ParameterizedType)cls).getActualTypeArguments()) {
                this.addType(t2);
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
        }
    }

    private void addClass(Class<?> cls) {
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            return;
        }
        if (Exception.class.isAssignableFrom(cls)) {
            for (Field f : cls.getDeclaredFields()) {
                this.addClass(f.getType());
            }
            this.addClass(String.class);
        } else if (null != (cls = JAXBUtils.getValidClass(cls))) {
            if (cls.isEnum()) {
                this.classes.add(cls);
            }
            String name = PackageUtils.getPackageName(cls) + ".ObjectFactory";
            try {
                cls = Class.forName(name, false, cls.getClassLoader());
                if (cls != null) {
                    this.classes.add(cls);
                }
            }
            catch (ClassNotFoundException ex) {
                this.classes.add(cls);
            }
        }
    }
}

