/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolderOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(HolderOutInterceptor.class.getName());

    public HolderOutInterceptor() {
        super("pre-logical");
        this.addBefore(WrapperClassOutInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        List<Object> outObjects = CastUtils.cast(message.getContent(List.class));
        Exchange exchange = message.getExchange();
        OperationInfo op = exchange.get(OperationInfo.class);
        LOG.fine("op: " + op);
        if (null != op) {
            LOG.fine("op.hasOutput(): " + op.hasOutput());
            if (op.hasOutput()) {
                LOG.fine("op.getOutput().size(): " + op.getOutput().size());
            }
        }
        if (op == null || !op.hasOutput() || op.getOutput().size() == 0) {
            LOG.fine("Returning.");
            return;
        }
        List<MessagePartInfo> parts = op.getOutput().getMessageParts();
        LOG.fine("output message parts: " + parts);
        if (Boolean.TRUE.equals(message.get("org.apache.cxf.client"))) {
            LOG.fine("client invocation");
            ArrayList<Holder> holders = new ArrayList<Holder>();
            int size = outObjects.size();
            ArrayList<Object> newObjects = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                newObjects.add(null);
            }
            Object deleteMarker = this.markOutHolderInParaList(outObjects, parts, holders, newObjects);
            if (holders.size() == 0) {
                return;
            }
            int i = 0;
            for (MessagePartInfo part : op.getInput().getMessageParts()) {
                List<String> ordering = part.getMessageInfo().getOperation().getParameterOrdering();
                if (ordering != null && ordering.size() > 0) {
                    int orderIdx = -1;
                    for (int j = 0; j < ordering.size(); ++j) {
                        if (!ordering.get(j).equals(part.getName().getLocalPart())) continue;
                        orderIdx = j;
                        break;
                    }
                    if (orderIdx != -1) {
                        newObjects.set(part.getIndex(), this.getValue(part, outObjects, orderIdx));
                    } else {
                        newObjects.set(part.getIndex(), this.getValue(part, outObjects, i));
                    }
                } else {
                    newObjects.set(part.getIndex(), this.getValue(part, outObjects, i));
                }
                ++i;
            }
            if (deleteMarker != null) {
                Object[] newObjectsArray = newObjects.toArray();
                newObjects.clear();
                for (Object param : newObjectsArray) {
                    if (param == deleteMarker) continue;
                    newObjects.add(param);
                }
            }
            message.setContent(List.class, newObjects);
            exchange.put("client.holders", holders);
        } else {
            List reqObjects = CastUtils.cast(exchange.getInMessage().getContent(List.class));
            int outIdx = 0;
            boolean holderOutIsFirst = false;
            for (MessagePartInfo part : parts) {
                if (part.getIndex() == -1) {
                    ++outIdx;
                    break;
                }
                holderOutIsFirst = true;
            }
            for (MessagePartInfo part : parts) {
                int methodIdx = part.getIndex();
                if (methodIdx < 0) continue;
                Holder holder = (Holder)reqObjects.get(methodIdx);
                Object o = holder.value;
                if (methodIdx < outIdx && holderOutIsFirst) {
                    outObjects.add(methodIdx, o);
                } else if (outIdx >= outObjects.size()) {
                    outObjects.add(o);
                } else {
                    outObjects.add(outIdx, o);
                }
                ++outIdx;
            }
            message.setContent(List.class, outObjects);
        }
    }

    private Object getValue(MessagePartInfo part, List<Object> outObjects, int idx) {
        if (part.getProperty("messagepart.mode.inout") != null) {
            Holder holder = (Holder)outObjects.get(idx);
            if (holder == null) {
                return null;
            }
            return holder.value;
        }
        return outObjects.get(idx);
    }

    private Object markOutHolderInParaList(List<Object> outObjects, List<MessagePartInfo> parts, List<Holder> holders, List<Object> newObjects) {
        Object deleteObject = null;
        for (MessagePartInfo part : parts) {
            int idx = part.getIndex();
            if (idx < 0) continue;
            Holder holder = (Holder)outObjects.get(idx);
            if (part.getProperty("messagepart.mode.out") != null) {
                if (deleteObject == null) {
                    deleteObject = new Object();
                }
                newObjects.set(idx, deleteObject);
            }
            holders.add(holder);
        }
        return deleteObject;
    }
}

