/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.util.List;
import javax.xml.ws.Binding;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.binding.BindingImpl;
import org.apache.cxf.jaxws.binding.http.HTTPBindingImpl;
import org.apache.cxf.jaxws.binding.soap.SOAPBindingImpl;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerFaultInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerFaultOutInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerOutInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerFaultInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerFaultOutInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.SwAInInterceptor;
import org.apache.cxf.jaxws.interceptors.SwAOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;

public class JaxWsEndpointImpl
extends EndpointImpl {
    private Binding jaxwsBinding;

    public JaxWsEndpointImpl(Bus bus, Service s, EndpointInfo ei) throws EndpointException {
        super(bus, s, ei);
        this.createJaxwsBinding();
        List<Interceptor> in = super.getInInterceptors();
        in.add(new LogicalHandlerInInterceptor(this.jaxwsBinding));
        in.add(new WrapperClassInInterceptor());
        in.add(new HolderInInterceptor());
        if (this.getBinding() instanceof SoapBinding) {
            in.add(new SOAPHandlerInterceptor(this.jaxwsBinding));
            in.add(new SwAInInterceptor());
            this.getOutInterceptors().add(new SwAOutInterceptor());
        }
        List<Interceptor> out = super.getOutInterceptors();
        out.add(new LogicalHandlerOutInterceptor(this.jaxwsBinding));
        out.add(new WrapperClassOutInterceptor());
        out.add(new HolderOutInterceptor());
        if (this.getBinding() instanceof SoapBinding) {
            out.add(new SOAPHandlerInterceptor(this.jaxwsBinding));
        }
        List<Interceptor> outFault = super.getOutFaultInterceptors();
        outFault.add(new LogicalHandlerFaultOutInterceptor(this.jaxwsBinding));
        if (this.getBinding() instanceof SoapBinding) {
            outFault.add(new SOAPHandlerFaultOutInterceptor(this.jaxwsBinding));
        }
        List<Interceptor> inFault = super.getInFaultInterceptors();
        inFault.add(new ClientFaultConverter());
        inFault.add(new LogicalHandlerFaultInInterceptor(this.jaxwsBinding));
        if (this.getBinding() instanceof SoapBinding) {
            inFault.add(new SOAPHandlerFaultInInterceptor(this.jaxwsBinding));
        }
    }

    public Binding getJaxwsBinding() {
        return this.jaxwsBinding;
    }

    final void createJaxwsBinding() {
        this.jaxwsBinding = this.getBinding() instanceof SoapBinding ? new SOAPBindingImpl(this.getEndpointInfo().getBinding()) : (this.getBinding() instanceof XMLBinding ? new HTTPBindingImpl(this.getEndpointInfo().getBinding()) : new BindingImpl());
    }
}

