/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceModelUtil {
    private ServiceModelUtil() {
    }

    public static Service getService(Exchange exchange) {
        return exchange.get(Service.class);
    }

    public static String getTargetNamespace(Exchange exchange) {
        return ServiceModelUtil.getService(exchange).getServiceInfos().get(0).getTargetNamespace();
    }

    public static BindingOperationInfo getOperation(Exchange exchange, String opName) {
        Endpoint ep = exchange.get(Endpoint.class);
        BindingInfo service = ep.getEndpointInfo().getBinding();
        for (BindingOperationInfo b : service.getOperations()) {
            if (!b.getName().getLocalPart().equals(opName)) continue;
            return b;
        }
        return null;
    }

    public static BindingOperationInfo getOperation(Exchange exchange, QName opName) {
        Endpoint ep = exchange.get(Endpoint.class);
        BindingInfo service = ep.getEndpointInfo().getBinding();
        return service.getOperation(opName);
    }

    public static SchemaInfo getSchema(ServiceInfo serviceInfo, MessagePartInfo messagePartInfo) {
        SchemaInfo schemaInfo = null;
        String tns = null;
        tns = messagePartInfo.isElement() ? messagePartInfo.getElementQName().getNamespaceURI() : messagePartInfo.getTypeQName().getNamespaceURI();
        for (SchemaInfo schema : serviceInfo.getSchemas()) {
            if (!tns.equals(schema.getNamespaceURI())) continue;
            schemaInfo = schema;
        }
        return schemaInfo;
    }

    public static List<String> getOperationInputPartNames(OperationInfo operation) {
        ArrayList<String> names = new ArrayList<String>();
        List<MessagePartInfo> parts = operation.getInput().getMessageParts();
        if (parts == null && parts.size() == 0) {
            return names;
        }
        for (MessagePartInfo part : parts) {
            XmlSchemaAnnotated schema = part.getXmlSchema();
            if (schema instanceof XmlSchemaElement && ((XmlSchemaElement)schema).getSchemaType() instanceof XmlSchemaComplexType) {
                XmlSchemaElement element = (XmlSchemaElement)schema;
                XmlSchemaComplexType cplxType = (XmlSchemaComplexType)element.getSchemaType();
                XmlSchemaSequence seq = (XmlSchemaSequence)cplxType.getParticle();
                if (seq == null || seq.getItems() == null) {
                    return names;
                }
                for (int i = 0; i < seq.getItems().getCount(); ++i) {
                    XmlSchemaElement elChild = (XmlSchemaElement)seq.getItems().getItem(i);
                    names.add(elChild.getName());
                }
                continue;
            }
            names.add(part.getConcreteName().getLocalPart());
        }
        return names;
    }
}

