/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal;

import org.apache.cxf.service.ServiceBuilder;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.processor.FrontendFactory;

public final class ServiceBuilderFactory {
    private static ServiceBuilderFactory instance;
    private Class serviceClass;
    private FrontendFactory frontend = FrontendFactory.getInstance();

    private ServiceBuilderFactory() {
    }

    public static ServiceBuilderFactory getInstance() {
        if (instance == null) {
            instance = new ServiceBuilderFactory();
        }
        return instance;
    }

    public ServiceBuilder newBuilder() {
        return this.newBuilder(this.getStyle());
    }

    public ServiceBuilder newBuilder(FrontendFactory.Style s) {
        ServiceBuilder builder = null;
        try {
            String clzName = this.getBuilderClassName(s);
            builder = (ServiceBuilder)Class.forName(clzName).newInstance();
        }
        catch (Exception e) {
            throw new ToolException("Can not find the ServiceBulider for style: " + (Object)((Object)s), (Throwable)e);
        }
        builder.setServiceClass(this.serviceClass);
        return builder;
    }

    protected String getBuilderClassName(FrontendFactory.Style s) {
        String pkgName = "org.apache.cxf";
        return pkgName + "." + s.toString().toLowerCase() + "." + (Object)((Object)s) + "ServiceBuilder";
    }

    public FrontendFactory.Style getStyle() {
        this.frontend.setServiceClass(this.serviceClass);
        return this.frontend.discoverStyle();
    }

    public void setServiceClass(Class c) {
        this.serviceClass = c;
    }
}

